/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.operators.impl;

import java.util.Arrays;
import java.util.List;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLArrayType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLLambdaType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLObjectType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.contentassist.operators.IDFLBinaryOperatorDescriptor;

public class MapOperatorDescriptor
implements IDFLBinaryOperatorDescriptor {
    @Override
    public String getName() {
        return "map";
    }

    @Override
    public List<List<IDFLType>> getValidParameterTypes() {
        return Arrays.asList(Arrays.asList(DFLTypeFactory.ANY_ARRAY, DFLTypeFactory.ANY_LAMBDA), Arrays.asList(DFLTypeFactory.ANY_OBJECT, DFLTypeFactory.ANY_LAMBDA));
    }

    @Override
    public IDFLType getReturnTypes(IDFLType left, IDFLType right) {
        if (left instanceof IDFLArrayType && right instanceof IDFLLambdaType) {
            IDFLType arrayType = ((IDFLArrayType)left).getType();
            IDFLType returnType = ((IDFLLambdaType)right).getReturnType(arrayType, DFLTypeFactory.NUMBER);
            return DFLTypeFactory.arrayOf(returnType);
        }
        if (left instanceof IDFLObjectType) {
            IDFLType returnType = ((IDFLLambdaType)right).getReturnType(left, DFLTypeFactory.NUMBER);
            return DFLTypeFactory.arrayOf(returnType);
        }
        return DFLTypeFactory.ANY_ARRAY;
    }

    @Override
    public String getLabel() {
        return "Map";
    }
}

