/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model.types;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.dFL.Using;
import org.mule.tooling.dfl.dFL.VariableDefinition;
import org.mule.tooling.dfl.ui.contentassist.DFLModelTypeResolverImpl;
import org.mule.tooling.dfl.ui.contentassist.model.EvaluationContext;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.AnyLambda;

public final class UsingLambdaType
extends AnyLambda {
    private final Using object;
    private EvaluationContext context;

    public UsingLambdaType(EvaluationContext context, Using object) {
        this.context = context;
        this.object = object;
    }

    @Override
    public IDFLType getReturnType(IDFLType ... args) {
        this.context.startFrame();
        try {
            List<String> parametersNames = this.getParametersNames();
            List<IDFLType> values = this.getDefaultValues();
            int i = 0;
            while (i < parametersNames.size()) {
                this.context.setValue(parametersNames.get(i), values.get(i));
                ++i;
            }
            IDFLType iDFLType = DFLModelTypeResolverImpl.create(this.context).getReturnType((EObject)this.object.getExpression());
            return iDFLType;
        }
        finally {
            this.context.endFrame();
        }
    }

    @Override
    public List<String> getParametersNames() {
        return Lists.transform((List)this.object.getParameters(), (Function)new Function<VariableDefinition, String>(){

            public String apply(VariableDefinition input) {
                return input.getName();
            }
        });
    }

    @Override
    public List<IDFLType> getDefaultValues() {
        return Lists.transform((List)this.object.getParameters(), (Function)new Function<VariableDefinition, IDFLType>(){

            public IDFLType apply(VariableDefinition input) {
                return DFLModelTypeResolverImpl.create(UsingLambdaType.this.context).getReturnType((EObject)input.getInitialValue());
            }
        });
    }
}

