/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model.types;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLArrayType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLLambdaType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLObjectType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLSimpleType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.utils.LazyVal;

public class ExtendedType
implements IDFLType {
    private LazyVal<IDFLType> type;
    private String name;
    private Map<String, Object> properties;

    public ExtendedType(LazyVal<IDFLType> type, String name, Map<String, Object> properties) {
        this.type = type;
        this.name = name;
        this.properties = properties;
    }

    @Override
    public boolean isAssignableFrom(IDFLType type) {
        if (type.getName().equals(this.name)) {
            return true;
        }
        return ((IDFLType)this.type.get()).isAssignableFrom(type);
    }

    public IDFLType getExtendedType() {
        return (IDFLType)this.type.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getSchemaKeys() {
        HashSet<String> result = new HashSet<String>(this.properties.keySet());
        result.addAll(((IDFLType)this.type.get()).getSchemaKeys());
        return result;
    }

    @Override
    public Optional<Object> getSchemaValue(String key) {
        Object value = this.properties.get(key);
        Optional<Object> schemaValue = ((IDFLType)this.type.get()).getSchemaValue(key);
        return value != null ? Optional.of(value) : schemaValue;
    }

    @Override
    public IDFLSimpleType asSimpleType() {
        return ((IDFLType)this.type.get()).asSimpleType();
    }

    @Override
    public IDFLArrayType asArrayType() {
        return ((IDFLType)this.type.get()).asArrayType();
    }

    @Override
    public IDFLObjectType asObjectType() {
        return ((IDFLType)this.type.get()).asObjectType();
    }

    @Override
    public IDFLLambdaType asLambdaType() {
        return ((IDFLType)this.type.get()).asLambdaType();
    }

    @Override
    public boolean isSimple() {
        return ((IDFLType)this.type.get()).isSimple();
    }

    @Override
    public boolean isArray() {
        return ((IDFLType)this.type.get()).isArray();
    }

    @Override
    public boolean isObject() {
        return ((IDFLType)this.type.get()).isObject();
    }

    @Override
    public boolean isLambda() {
        return ((IDFLType)this.type.get()).isLambda();
    }

    @Override
    public String textRepresentation(int tabulation) {
        return ((IDFLType)this.type.get()).textRepresentation(tabulation) + " as " + this.name + " " + String.valueOf(this.properties);
    }
}

