/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model.types;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLArrayType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLLambdaType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLObjectType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLSimpleType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.utils.ListHelper;
import org.mule.tooling.utils.SetHelper;

public class DefaultObjectDFLModelType
implements IDFLObjectType {
    private List<IDFLField> fields;
    private String name = "Object";

    public DefaultObjectDFLModelType(List<IDFLField> fields) {
        this.fields = fields;
    }

    public DefaultObjectDFLModelType(List<IDFLField> fields, String objectName) {
        this(fields);
        this.name = objectName;
    }

    @Override
    public boolean isAssignableFrom(IDFLType type) {
        return type instanceof IDFLObjectType;
    }

    @Override
    public List<IDFLField> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getSchemaKeys() {
        return SetHelper.setOf((Object[])new String[]{"class"});
    }

    @Override
    public Optional<Object> getSchemaValue(String key) {
        return Optional.empty();
    }

    @Override
    public IDFLSimpleType asSimpleType() {
        throw new RuntimeException(String.valueOf(this.getClass()) + " is not a simple type");
    }

    @Override
    public IDFLArrayType asArrayType() {
        throw new RuntimeException(String.valueOf(this.getClass()) + " is not a array type");
    }

    @Override
    public IDFLObjectType asObjectType() {
        return this;
    }

    @Override
    public IDFLLambdaType asLambdaType() {
        throw new RuntimeException(String.valueOf(this.getClass()) + " is not an lambda type");
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isLambda() {
        return false;
    }

    @Override
    public String textRepresentation(final int tabulation) {
        Iterable transform = Iterables.transform(this.fields, (Function)new Function<IDFLField, String>(){

            public String apply(IDFLField arg0) {
                return arg0.textRepresentation(tabulation + 1);
            }
        });
        String reduce = (String)ListHelper.reduce((Iterable)transform, (ListHelper.ReduceFunction)new ListHelper.ReduceFunction<String>(){

            public String apply(String arg1, String arg2) {
                return arg1 + ",\n" + arg2;
            }
        });
        return "{" + (String)(reduce != null ? "\n" + reduce + "\n" + StringUtils.repeat((String)" ", (int)tabulation) : "Empty") + "}";
    }
}

