/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model.types;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.ui.contentassist.DFLModelTypeResolverImpl;
import org.mule.tooling.dfl.ui.contentassist.model.EvaluationContext;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLLambdaType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.AbstractDFLLamdaType;

public class DefaultDFLLambdaType
extends AbstractDFLLamdaType {
    private EvaluationContext context;
    private EObject function;
    private List<String> paramNames;
    private List<EObject> defaultValue;

    public DefaultDFLLambdaType(EvaluationContext context, EObject function, List<String> paramNames, List<EObject> defaultValue) {
        this.context = context;
        this.function = function;
        this.paramNames = paramNames;
        this.defaultValue = defaultValue;
    }

    @Override
    public IDFLType getReturnType(IDFLType ... args) {
        this.context.startFrame();
        int i = 0;
        while (i < this.paramNames.size()) {
            String name = this.paramNames.get(i);
            this.context.setValue(name, args[i]);
            ++i;
        }
        IDFLType doSwitch = DFLModelTypeResolverImpl.create(this.context).getReturnType(this.function);
        this.context.endFrame();
        return doSwitch;
    }

    @Override
    public boolean isAssignableFrom(IDFLType type) {
        return type instanceof IDFLLambdaType;
    }

    @Override
    public List<String> getParametersNames() {
        return this.paramNames;
    }

    @Override
    public List<IDFLType> getDefaultValues() {
        return Lists.transform(this.defaultValue, (Function)new Function<EObject, IDFLType>(){

            public IDFLType apply(EObject input) {
                DFLModelTypeResolverImpl typeResolver = DFLModelTypeResolverImpl.create(DefaultDFLLambdaType.this.context);
                return typeResolver.getReturnType(input);
            }
        });
    }

    @Override
    public String textRepresentation(int tabulation) {
        return "lambda(" + String.valueOf(this.getParametersNames()) + ")";
    }
}

