/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model.types;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;

public class DefaultDFLField
implements IDFLField {
    private QName name;
    private IDFLType type;
    private List<IDFLField> attributes;
    private Optional<String> label;

    public DefaultDFLField(QName name, IDFLType type) {
        this(name, type, Collections.emptyList());
    }

    public DefaultDFLField(QName name, IDFLType type, List<IDFLField> attributes) {
        this(name, type, attributes, Optional.empty());
    }

    public DefaultDFLField(QName name, IDFLType type, List<IDFLField> attributes, String label) {
        this(name, type, attributes, Optional.ofNullable(label));
    }

    public DefaultDFLField(QName name, IDFLType type, List<IDFLField> attributes, Optional<String> label) {
        this.name = name;
        this.type = type;
        this.attributes = attributes;
        this.label = label;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public IDFLType getType() {
        return this.type;
    }

    @Override
    public List<IDFLField> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return String.valueOf(this.name);
    }

    @Override
    public Optional<String> getLabel() {
        return this.label;
    }

    public static boolean isUnboundedArray(IDFLField field) {
        IDFLType type = field.getType();
        return type.isArray() && type.asArrayType().isUnbounded();
    }

    @Override
    public String textRepresentation(int tabulation) {
        return StringUtils.repeat((String)" ", (int)tabulation) + String.valueOf(this.getName()) + ": " + this.getType().textRepresentation(tabulation);
    }
}

