/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model.types;

import java.util.Optional;
import java.util.Set;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLArrayType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLLambdaType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLObjectType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLSimpleType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.utils.SetHelper;

public class DefaultArrayDFLModelType
implements IDFLArrayType {
    private static final String ARRAY_TYPE_NAME = "Array";
    private IDFLType type;
    private String typeName = "Array";
    private boolean unbounded = false;

    public DefaultArrayDFLModelType(IDFLType type) {
        this(type, false);
    }

    public DefaultArrayDFLModelType(IDFLType type, boolean unbounded) {
        this(type, ARRAY_TYPE_NAME, unbounded);
    }

    public DefaultArrayDFLModelType(IDFLType type, String typeName) {
        this(type, typeName, false);
    }

    public DefaultArrayDFLModelType(IDFLType type, String typeName, boolean unbounded) {
        this.type = type;
        this.typeName = typeName;
        this.unbounded = unbounded;
    }

    @Override
    public boolean isAssignableFrom(IDFLType otherType) {
        if (otherType instanceof IDFLArrayType) {
            IDFLArrayType otherArrayType = (IDFLArrayType)otherType;
            return this.type.isAssignableFrom(otherArrayType.getType());
        }
        return false;
    }

    @Override
    public IDFLType getType() {
        return this.type;
    }

    public String toString() {
        return "Array[" + String.valueOf(this.getType()) + "]";
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public Set<String> getSchemaKeys() {
        return SetHelper.setOf((Object[])new String[]{"class"});
    }

    @Override
    public Optional<Object> getSchemaValue(String key) {
        return Optional.empty();
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isLambda() {
        return false;
    }

    @Override
    public boolean isUnbounded() {
        return this.unbounded;
    }

    @Override
    public IDFLSimpleType asSimpleType() {
        throw new RuntimeException(String.valueOf(this.getClass()) + " is not a simple type");
    }

    @Override
    public IDFLArrayType asArrayType() {
        return this;
    }

    @Override
    public IDFLObjectType asObjectType() {
        throw new RuntimeException(String.valueOf(this.getClass()) + " is not an object type");
    }

    @Override
    public IDFLLambdaType asLambdaType() {
        throw new RuntimeException(String.valueOf(this.getClass()) + " is not an lambda type");
    }

    @Override
    public String textRepresentation(int tabulation) {
        return "[" + this.getType().textRepresentation(tabulation) + "] as " + this.getName() + "<" + String.valueOf(this.getSchemaKeys()) + ">";
    }

    @Override
    public IDFLType withType(IDFLType type) {
        return new DefaultArrayDFLModelType(type, this.isUnbounded());
    }
}

