/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model.types;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.tooling.client.metadata.MetadataFactory;
import org.mule.tooling.dfl.dFL.ClojureOperator;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FilterSelector;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.LambdaLiteral;
import org.mule.tooling.dfl.ui.contentassist.model.DFLTypeSystem;
import org.mule.tooling.dfl.ui.contentassist.model.EvaluationContext;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLArrayType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLLambdaType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLObjectType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.AnyDFLModelType;
import org.mule.tooling.dfl.ui.contentassist.model.types.AnyLambda;
import org.mule.tooling.dfl.ui.contentassist.model.types.DefaultArrayDFLModelType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DefaultDFLField;
import org.mule.tooling.dfl.ui.contentassist.model.types.DefaultDFLLambdaType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DefaultObjectDFLModelType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DefaultSimpleDFLModelType;
import org.mule.tooling.dfl.ui.contentassist.model.types.EnumDFLModelType;
import org.mule.tooling.dfl.ui.contentassist.model.types.ExtendedType;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.dfl.ui.metadata.MetadataTypeWrapper;
import org.mule.tooling.dfl.ui.metadata.RecursionHandler;
import org.mule.tooling.ui.modules.core.metadata.MetadataTypeHelper;
import org.mule.tooling.utils.LazyVal;
import org.mule.tooling.utils.Pair;

public class DFLTypeFactory {
    public static final IDFLType REGEX = new DefaultSimpleDFLModelType("Regex", "class");
    public static final IDFLType UNKNOWN = new DefaultSimpleDFLModelType("?", new String[0]);
    public static final IDFLType ANY_LAMBDA = new AnyLambda();
    public static final IDFLType STRING = new DefaultSimpleDFLModelType("String", "class", "format");
    public static final IDFLType BINARY = new DefaultSimpleDFLModelType("Binary", "class");
    public static final IDFLType ANY = new AnyDFLModelType("Any");
    public static final IDFLArrayType ANY_ARRAY = new DefaultArrayDFLModelType(ANY);
    public static final IDFLObjectType ANY_OBJECT = new DefaultObjectDFLModelType(Collections.emptyList());
    public static final IDFLType BOOLEAN = new DefaultSimpleDFLModelType("Boolean", "class");
    public static final IDFLType TYPE = new DefaultSimpleDFLModelType("Type", new String[0]);
    public static final IDFLType NUMBER = new DefaultSimpleDFLModelType("Number", "class", "format");
    public static final IDFLType RANGE = new DefaultArrayDFLModelType(NUMBER, "Range");
    public static final IDFLType URI = new DefaultSimpleDFLModelType("Uri", "class");
    public static final IDFLType DATE = new DefaultSimpleDFLModelType("Date", "class", "format");
    public static final IDFLType DATETIME = new DefaultSimpleDFLModelType("DateTime", "class", "format");
    public static final IDFLType LOCALDATETIME = new DefaultSimpleDFLModelType("LocalDateTime", "class", "format");
    public static final IDFLType LOCALTIME = new DefaultSimpleDFLModelType("LocalTime", "class", "format");
    public static final IDFLType TIME = new DefaultSimpleDFLModelType("Time", "class", "format");
    public static final IDFLType TIMEZONE = new DefaultSimpleDFLModelType("Timezone", "class", "format");
    public static final IDFLType PERIOD = new DefaultSimpleDFLModelType("Period", "class", "format");
    public static final IDFLType NULL = new DefaultSimpleDFLModelType("Null", new String[0]);
    public static final IDFLType ITERATOR = new DefaultArrayDFLModelType(ANY, "Iterator");
    public static final IDFLType CDATA = DFLTypeFactory.extendFrom(STRING, "CData", new HashMap<String, Object>());
    private static final IDFLType MULE_MESSAGE = DFLTypeFactory.createMuleMessage();
    private static final IDFLType ERROR_TYPE = DFLTypeFactory.createErrorType();
    private static final IDFLType THROWABLE = DFLTypeFactory.createThrowable();
    public static final IDFLType ERROR = DFLTypeFactory.createError();
    private static Pair<? extends MetadataType, ? extends IDFLType> previousResult = Pair.of((Object)MetadataFactory.undefined(), (Object)UNKNOWN);

    public static IDFLType extendFrom(final DFLTypeSystem typeSytem, final String type, String name, Map<String, Object> properties) {
        return new ExtendedType(new LazyVal<IDFLType>(){

            protected IDFLType doGet() {
                Optional<IDFLType> lookupType = typeSytem.lookupType(type);
                return lookupType.orElse(UNKNOWN);
            }
        }, name, properties);
    }

    public static IDFLType extendFrom(final IDFLType from, String name, Map<String, Object> properties) {
        return new ExtendedType(new LazyVal<IDFLType>(){

            protected IDFLType doGet() {
                return from;
            }
        }, name, properties);
    }

    public static IDFLType fromMetaDataProperties(ObjectType variables) {
        ArrayList<IDFLField> propertyFields = new ArrayList<IDFLField>();
        Collection fields = variables.getFields();
        for (ObjectFieldType field : fields) {
            QName qName;
            MetadataType metadataType = field.getValue();
            RecursionHandler recursionHandler = new RecursionHandler();
            HashMap<MetadataTypeWrapper, IDFLType> typedObjects = new HashMap<MetadataTypeWrapper, IDFLType>();
            if (MetadataFormat.XML.equals((Object)metadataType.getMetadataFormat())) {
                qName = MetadataTypeHelper.toQName((ObjectFieldType)field);
                List<IDFLField> attributes = DFLTypeFactory.toDFLFields(MetadataTypeHelper.getAttributeFields((ObjectFieldType)field));
                recursionHandler.add(recursionHandler.newField(qName, metadataType));
                IDFLField dflField = DFLTypeFactory.field(qName, DFLTypeFactory.fromMetadataType(metadataType, recursionHandler, typedObjects), attributes);
                propertyFields.add(dflField);
                continue;
            }
            qName = MetadataTypeHelper.toQName((ObjectFieldType)field);
            IDFLField dflField = DFLTypeFactory.field(qName, DFLTypeFactory.fromMetadataType(metadataType, recursionHandler, typedObjects));
            propertyFields.add(dflField);
        }
        return DFLTypeFactory.objectWith(propertyFields);
    }

    public static IDFLType fromMetadataType(MetadataType model) {
        if (((MetadataType)previousResult.getLeft()).equals(model)) {
            return (IDFLType)previousResult.getRight();
        }
        return DFLTypeFactory.fromMetadataType(model, new RecursionHandler(), Maps.newHashMap());
    }

    public static IDFLType fromMetadataType(MetadataType model, RecursionHandler recursionHandler, Map<MetadataTypeWrapper, IDFLType> typedObjects) {
        return DFLTypeFactory.toMetadata(model, recursionHandler, typedObjects);
    }

    public static Optional<IDFLType> fromMetadataType(Optional<MetadataType> modelOpt) {
        return modelOpt.map(DFLTypeFactory::fromMetadataType);
    }

    private static IDFLType toMetadata(MetadataType model, RecursionHandler recursionHandler, Map<MetadataTypeWrapper, IDFLType> typedObjects) {
        IDFLType result;
        if (model instanceof ObjectFieldType) {
            ObjectFieldType objectFieldType = (ObjectFieldType)model;
            IDFLType dflType = DFLTypeFactory.toMetadata(objectFieldType.getValue(), recursionHandler, typedObjects);
            result = objectFieldType.isRepeated() ? DFLTypeFactory.arrayOf(dflType, true) : dflType;
        } else {
            if (model instanceof FunctionType) {
                return ANY_LAMBDA;
            }
            if (model instanceof ObjectType) {
                MetadataTypeWrapper metaDataModelWrapper = new MetadataTypeWrapper(model);
                IDFLType dflType = typedObjects.get(metaDataModelWrapper);
                if (dflType == null) {
                    IDFLObjectType dflObjectType = DFLTypeFactory.objectWith(new ArrayList<IDFLField>(), MetadataTypeHelper.getName((MetadataType)model));
                    typedObjects.put(metaDataModelWrapper, dflObjectType);
                    Collection fields = ((ObjectType)model).getFields();
                    List<IDFLField> objectDFLFields = DFLTypeFactory.toObjectDFLFields(fields, recursionHandler, typedObjects);
                    for (IDFLField idflField : objectDFLFields) {
                        dflObjectType.getFields().add(idflField);
                    }
                    dflType = dflObjectType;
                }
                result = dflType;
            } else if (model instanceof ArrayType) {
                MetadataType listElementModel = ((ArrayType)model).getType();
                IDFLType dflType = DFLTypeFactory.toMetadata(listElementModel, recursionHandler, typedObjects);
                Optional lengthAnnotation = model.getAnnotation(LengthAnnotation.class);
                result = DFLTypeFactory.arrayOf(dflType, !lengthAnnotation.flatMap(LengthAnnotation::getMax).isPresent());
            } else {
                result = model instanceof StringType ? STRING : (model instanceof BooleanType ? BOOLEAN : (model instanceof BinaryType ? BINARY : (model instanceof DateType ? DATE : (model instanceof DateTimeType ? DATETIME : (model instanceof NumberType ? NUMBER : NULL)))));
            }
        }
        return result;
    }

    public static IDFLArrayType arrayOf(IDFLType type) {
        return new DefaultArrayDFLModelType(type);
    }

    public static IDFLArrayType arrayOf(IDFLType type, boolean unbounded) {
        return new DefaultArrayDFLModelType(type, unbounded);
    }

    public static IDFLArrayType arrayOf(IDFLType type, String typeName, boolean unbounded) {
        return new DefaultArrayDFLModelType(type, typeName, unbounded);
    }

    public static IDFLLambdaType lambdaOf(EvaluationContext context, ClojureOperatorOrOrExpression object) {
        if (object.getOrExpression() != null) {
            Expression expression = object.getOrExpression();
            if (DflFactoryUtils.fromEnclosedExpressionToChild(expression) instanceof LambdaLiteral) {
                return DFLTypeFactory.lambdaOf(context, (LambdaLiteral)DflFactoryUtils.fromEnclosedExpressionToChild(expression));
            }
            return DFLTypeFactory.lambdaOf(context, expression);
        }
        ClojureOperator clojureOperator = object.getClojureOperator();
        return DFLTypeFactory.lambdaOf(context, clojureOperator);
    }

    public static IDFLLambdaType lambdaOf(EvaluationContext context, ClojureOperator object) {
        return new DefaultDFLLambdaType(context, (EObject)object.getExpression(), DFLTypeFactory.getParametersNames(object), DFLTypeFactory.getDefaultValues(object));
    }

    public static IDFLLambdaType lambdaOf(EvaluationContext context, LambdaLiteral object) {
        return new DefaultDFLLambdaType(context, (EObject)object.getExpression(), DFLTypeFactory.getParametersNames(object), DFLTypeFactory.getDefaultValues(object));
    }

    public static IDFLLambdaType lambdaOf(EvaluationContext context, Expression object) {
        return new DefaultDFLLambdaType(context, (EObject)object, Arrays.asList("$", "$$"), new ArrayList<EObject>());
    }

    public static IDFLLambdaType lambdaOf(EvaluationContext context, FilterSelector object) {
        return new DefaultDFLLambdaType(context, (EObject)object.getExpression(), Arrays.asList("$"), new ArrayList<EObject>());
    }

    private static List<String> getParametersNames(ClojureOperator clojureOperator) {
        ArrayList<String> paramNames = new ArrayList<String>(2);
        FunctionParameter param1 = clojureOperator.getParam1();
        if (param1 != null) {
            paramNames.add(param1.getName());
            FunctionParameter param2 = clojureOperator.getParam2();
            if (param2 != null) {
                paramNames.add(param2.getName());
            } else {
                paramNames.add("$$");
            }
        } else {
            paramNames.add("$");
        }
        return paramNames;
    }

    private static List<EObject> getDefaultValues(ClojureOperator object) {
        return Stream.of(object.getParam1(), object.getParam2()).filter(input -> input != null).map(input -> input.getInitialValue()).filter(input -> input != null).collect(Collectors.toList());
    }

    private static List<String> getParametersNames(LambdaLiteral object) {
        FunctionParameter param1;
        ArrayList<String> paramNames = new ArrayList<String>(2);
        EList fParameters = object.getFParameters();
        int parametersSize = fParameters.size();
        FunctionParameter functionParameter = param1 = parametersSize > 0 ? (FunctionParameter)fParameters.get(0) : null;
        if (param1 != null) {
            FunctionParameter param2;
            paramNames.add(param1.getName());
            FunctionParameter functionParameter2 = param2 = parametersSize > 1 ? (FunctionParameter)fParameters.get(1) : null;
            if (param2 != null) {
                paramNames.add(param2.getName());
            } else {
                paramNames.add("$$");
            }
        } else {
            paramNames.add("$");
        }
        return paramNames;
    }

    private static List<EObject> getDefaultValues(LambdaLiteral object) {
        return object.getFParameters().stream().map(input -> input.getInitialValue()).filter(input -> input != null).collect(Collectors.toList());
    }

    public static IDFLLambdaType lambdaOf(EvaluationContext context, EObject function, List<String> names) {
        return new DefaultDFLLambdaType(context, function, names, Collections.emptyList());
    }

    public static IDFLObjectType enumWith(String name, List<IDFLField> fields) {
        return new EnumDFLModelType(name, fields);
    }

    public static IDFLObjectType objectWith(List<IDFLField> fields) {
        return new DefaultObjectDFLModelType(fields);
    }

    public static IDFLObjectType objectWith(List<IDFLField> fields, String objectName) {
        if (StringUtils.isBlank((String)objectName)) {
            return new DefaultObjectDFLModelType(fields);
        }
        return new DefaultObjectDFLModelType(fields, objectName);
    }

    public static IDFLField field(QName name, IDFLType type) {
        return new DefaultDFLField(name, type);
    }

    public static IDFLField field(QName name, IDFLType type, List<IDFLField> attributes) {
        return new DefaultDFLField(name, type, attributes);
    }

    public static IDFLField field(QName name, IDFLType type, List<IDFLField> attributes, Optional<String> label) {
        return new DefaultDFLField(name, type, attributes, label);
    }

    private static List<IDFLField> toDFLFields(Collection<AttributeFieldType> attributes, RecursionHandler recursionHandler, Map<MetadataTypeWrapper, IDFLType> typedObjects) {
        return attributes.stream().map(attribute -> DFLTypeFactory.field(MetadataTypeHelper.toQName((AttributeFieldType)attribute), DFLTypeFactory.toMetadata(attribute.getValue(), new RecursionHandler(recursionHandler), typedObjects), Collections.emptyList(), DFLTypeFactory.getFieldLabel((MetadataType)attribute))).collect(Collectors.toList());
    }

    private static List<IDFLField> toObjectDFLFields(Collection<ObjectFieldType> fields, RecursionHandler recursionHandler, Map<MetadataTypeWrapper, IDFLType> typedObjects) {
        return fields.stream().map(field -> DFLTypeFactory.field(MetadataTypeHelper.toQName((ObjectFieldType)field), DFLTypeFactory.toMetadata((MetadataType)field, new RecursionHandler(recursionHandler), typedObjects), DFLTypeFactory.toDFLFields(field.getKey().getAttributes()), DFLTypeFactory.getFieldLabel((MetadataType)field))).collect(Collectors.toList());
    }

    private static List<IDFLField> toDFLFields(Collection<AttributeFieldType> collection) {
        return DFLTypeFactory.toDFLFields(collection, new RecursionHandler(), Maps.newHashMap());
    }

    public static Optional<String> getFieldLabel(MetadataType metaDataField) {
        Optional labelMetaDataProperty = metaDataField.getAnnotation(LabelAnnotation.class);
        return labelMetaDataProperty.map(LabelAnnotation::getValue);
    }

    private static IDFLType createError() {
        ArrayList<IDFLField> fields = new ArrayList<IDFLField>(5);
        fields.add(new DefaultDFLField(new QName("description"), STRING));
        fields.add(new DefaultDFLField(new QName("detailedDescription"), STRING));
        fields.add(new DefaultDFLField(new QName("errorType"), ERROR_TYPE));
        fields.add(new DefaultDFLField(new QName("exception"), THROWABLE));
        fields.add(new DefaultDFLField(new QName("muleMessage"), MULE_MESSAGE));
        return DFLTypeFactory.objectWith(fields, "Error");
    }

    private static IDFLType createErrorType() {
        ArrayList<IDFLField> fields = new ArrayList<IDFLField>(3);
        fields.add(new DefaultDFLField(new QName("identifier"), STRING));
        fields.add(new DefaultDFLField(new QName("namespace"), STRING));
        IDFLObjectType errorType = DFLTypeFactory.objectWith(fields, "ErrorType");
        fields.add(new DefaultDFLField(new QName("parentErrorType"), errorType));
        return errorType;
    }

    private static IDFLType createThrowable() {
        ArrayList<IDFLField> fields = new ArrayList<IDFLField>(4);
        fields.add(new DefaultDFLField(new QName("backtrace"), ANY_OBJECT));
        fields.add(new DefaultDFLField(new QName("detailMessage"), STRING));
        fields.add(new DefaultDFLField(new QName("message"), STRING));
        IDFLObjectType throwableType = DFLTypeFactory.objectWith(fields, "Throwable");
        fields.add(new DefaultDFLField(new QName("cause"), throwableType));
        return throwableType;
    }

    private static IDFLType createMuleMessage() {
        ArrayList<IDFLField> fields = new ArrayList<IDFLField>(2);
        fields.add(new DefaultDFLField(new QName("payload"), ANY_OBJECT));
        fields.add(new DefaultDFLField(new QName("attributes"), ANY_OBJECT));
        return DFLTypeFactory.objectWith(fields, "Message");
    }
}

