/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.utils.InMemoryFile;
import org.mule.tooling.utils.SimpleContentHandler;

public class WeaveModulesManager {
    public static final String CORE_MODULE_PATH = "dw::Core";
    private static final String CORE_MODULES_DIR = "modules";
    private Map<String, Document> modules = new HashMap<String, Document>();

    public static WeaveModulesManager getInstance() {
        return Singleton.INSTANCE;
    }

    public Document getModule(String modulePath) {
        Document module = this.modules.get(modulePath);
        if (module != null) {
            return module;
        }
        return this.processDocument(modulePath);
    }

    private Document processDocument(String modulePath) {
        Optional<Document> maybeDocument = this.parseDocument(modulePath);
        maybeDocument.ifPresent(document -> this.modules.put(modulePath, (Document)document));
        return maybeDocument.orElse(null);
    }

    public Optional<Document> parseDocument(String modulePath) {
        String resolvedModulePath = "modules/" + modulePath.replaceAll("::", "/") + ".dwl";
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream openStream = FileLocator.resolve((URL)DFLExtendedActivator.getInstance().getBundle().getResource(resolvedModulePath)).openStream();){
                String moduleScript = IOUtils.toString((InputStream)openStream);
                IFile inMemoryFile = InMemoryFile.createInMemoryFile((String)resolvedModulePath, (InMemoryFile.IContentHandler)new SimpleContentHandler(moduleScript), (IWorkspace)ResourcesPlugin.getWorkspace());
                return Optional.ofNullable((Document)Platform.getAdapterManager().getAdapter((Object)inMemoryFile, Document.class));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static class Singleton {
        private static final WeaveModulesManager INSTANCE = new WeaveModulesManager();

        private Singleton() {
        }
    }
}

