/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.Content;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.FilterSelector;
import org.mule.tooling.dfl.dFL.FunctionDirective;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.ImportModuleOnly;
import org.mule.tooling.dfl.dFL.ImportWithSubElements;
import org.mule.tooling.dfl.dFL.ImportedElement;
import org.mule.tooling.dfl.dFL.SingleImportedElement;
import org.mule.tooling.dfl.dFL.StarImportedElement;
import org.mule.tooling.dfl.dFL.Using;
import org.mule.tooling.dfl.dFL.VariableDefinition;
import org.mule.tooling.dfl.dFL.VariableDirective;
import org.mule.tooling.dfl.ui.contentassist.DFLModelTypeResolver;
import org.mule.tooling.dfl.ui.contentassist.DFLModelTypeResolverImpl;
import org.mule.tooling.dfl.ui.contentassist.model.EvaluationContext;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLLambdaType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.WeaveModulesManager;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.contentassist.operators.DefaultDFLContextPopulator;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.util.DFLModelHelper;

public class EvaluationContextUtils {
    public static Map<String, IDFLType> createVariableContext(EObject currentModel, IMetaDataProvider inputMetadata) {
        Map<String, IDFLType> constTypes = EvaluationContextUtils.loadConstantTypes(currentModel, inputMetadata);
        Stack<EObject> lamdas = new Stack<EObject>();
        constTypes.put("error", DFLTypeFactory.ERROR);
        if (currentModel != null) {
            EObject eContainer = currentModel.eContainer();
            while (!(eContainer instanceof Content) && eContainer != null) {
                if (eContainer instanceof ClojureOperatorOrOrExpression || eContainer instanceof FunctionDirective || eContainer instanceof FilterSelector) {
                    lamdas.push(eContainer);
                } else {
                    EList eContents = eContainer.eContents();
                    for (EObject eObject : eContents) {
                        if (!(eObject instanceof Using)) continue;
                        lamdas.push(eObject);
                    }
                }
                eContainer = eContainer.eContainer();
            }
        }
        while (!lamdas.isEmpty()) {
            IDFLType type;
            EList parameters;
            IDFLLambdaType lambdaType;
            EObject pop = (EObject)lamdas.pop();
            if (pop instanceof ClojureOperatorOrOrExpression) {
                lambdaType = DFLTypeFactory.lambdaOf(EvaluationContextUtils.newContext(constTypes, inputMetadata), (ClojureOperatorOrOrExpression)pop);
                EObject operator = pop.eContainer();
                Iterator eContents = operator.eContents();
                EObject left = (EObject)eContents.get(0);
                IDFLType leftType = DFLModelTypeResolverImpl.create(EvaluationContextUtils.newContext(constTypes, inputMetadata)).getReturnType(left);
                constTypes.putAll(new DefaultDFLContextPopulator().populate(leftType, lambdaType));
                continue;
            }
            if (pop instanceof Using) {
                parameters = ((Using)pop).getParameters();
                for (VariableDefinition variableDefinition : parameters) {
                    type = DFLModelTypeResolverImpl.create(EvaluationContextUtils.newContext(constTypes, inputMetadata)).getReturnType((EObject)variableDefinition.getInitialValue());
                    constTypes.put(variableDefinition.getName(), type);
                }
                continue;
            }
            if (pop instanceof FunctionDirective) {
                parameters = ((FunctionDirective)pop).getFunction().getFParameters();
                for (FunctionParameter parameter : parameters) {
                    type = DFLModelTypeResolverImpl.create(EvaluationContextUtils.newContext(constTypes, inputMetadata)).getReturnType((EObject)parameter.getInitialValue());
                    constTypes.put(parameter.getName(), type);
                }
                continue;
            }
            if (!(pop instanceof FilterSelector)) continue;
            lambdaType = DFLTypeFactory.lambdaOf(EvaluationContextUtils.newContext(constTypes, inputMetadata), (FilterSelector)pop);
            EList eContents = pop.eContents();
            EObject left = (EObject)eContents.get(0);
            IDFLType leftType = DFLModelTypeResolverImpl.create(EvaluationContextUtils.newContext(constTypes, inputMetadata)).getReturnType(left);
            constTypes.putAll(new DefaultDFLContextPopulator().populate(leftType, lambdaType));
        }
        return constTypes;
    }

    public static EvaluationContext newContext(Map<String, IDFLType> constTypes, IMetaDataProvider inputMetadata) {
        return new EvaluationContext(inputMetadata, constTypes);
    }

    public static EvaluationContext newContext(EObject model, IMetaDataProvider inputMetadata) {
        return new EvaluationContext(inputMetadata, EvaluationContextUtils.createVariableContext(model, inputMetadata));
    }

    public static Map<String, IDFLType> loadConstantTypes(EObject currentModel, IMetaDataProvider inputMetadata) {
        HashMap<String, IDFLType> constTypes = new HashMap<String, IDFLType>();
        DFLModelTypeResolverImpl typeResolver = DFLModelTypeResolverImpl.create(EvaluationContextUtils.newContext(constTypes, inputMetadata));
        Document rootDocument = DFLModelHelper.getRootDocument((EObject)currentModel);
        Document core = WeaveModulesManager.getInstance().getModule("dw::Core");
        EvaluationContextUtils.processModule(core, constTypes, typeResolver, "", EvaluationContextUtils.starImport());
        EvaluationContextUtils.processMainModule(rootDocument, constTypes, typeResolver);
        return constTypes;
    }

    private static Map<String, String> starImport() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("*", null);
        return map;
    }

    private static void processMainModule(Document rootDocument, Map<String, IDFLType> constTypes, DFLModelTypeResolver typeResolver) {
        EvaluationContextUtils.processImports(rootDocument, constTypes, typeResolver);
        EvaluationContextUtils.processModule(rootDocument, constTypes, typeResolver, "", EvaluationContextUtils.starImport());
    }

    private static void processModule(Document document, Map<String, IDFLType> constTypes, DFLModelTypeResolver typeResolver, String prefix, Map<String, String> elementsToBeImported) {
        EvaluationContextUtils.processVariables(constTypes, typeResolver, document, prefix, elementsToBeImported);
        EvaluationContextUtils.processFunctions(constTypes, typeResolver, document, prefix, elementsToBeImported);
    }

    private static void processVariables(Map<String, IDFLType> constTypes, DFLModelTypeResolver typeResolver, Document rootDocument, String prefix, Map<String, String> elementsToBeImported) {
        List varDirectives = DFLModelHelper.getVarDirectives((Document)rootDocument);
        boolean starImport = elementsToBeImported.containsKey("*");
        for (VariableDirective varDirective : varDirectives) {
            String resolvedName = elementsToBeImported.get(varDirective.getName());
            if (resolvedName != null) {
                constTypes.put(prefix + resolvedName, typeResolver.getReturnType((EObject)varDirective.getExpression()));
                continue;
            }
            if (!starImport) continue;
            constTypes.put(prefix + varDirective.getName(), typeResolver.getReturnType((EObject)varDirective.getExpression()));
        }
    }

    private static void processFunctions(Map<String, IDFLType> constTypes, DFLModelTypeResolver typeResolver, Document rootDocument, String prefix, Map<String, String> elementsToBeImported) {
        List functionDirectives = DFLModelHelper.getFunctionDirectives((Document)rootDocument);
        boolean starImport = elementsToBeImported.containsKey("*");
        for (FunctionDirective functionDirective : functionDirectives) {
            String resolvedName = elementsToBeImported.get(functionDirective.getName());
            if (resolvedName != null) {
                constTypes.put(prefix + resolvedName, typeResolver.getReturnType((EObject)functionDirective));
                continue;
            }
            if (!starImport) continue;
            constTypes.put(prefix + functionDirective.getName(), typeResolver.getReturnType((EObject)functionDirective));
        }
    }

    private static void processImports(Document rootDocument, Map<String, IDFLType> constTypes, DFLModelTypeResolver typeResolver) {
        List importsWithSubElements = DFLModelHelper.getImportsWithSubElements((Document)rootDocument);
        for (ImportWithSubElements importWithSubElements : importsWithSubElements) {
            EList elements = importWithSubElements.getElements();
            HashMap<String, String> elementsToBeImported = new HashMap<String, String>();
            for (ImportedElement importedElement : elements) {
                if (importedElement instanceof SingleImportedElement) {
                    String resolvedName;
                    SingleImportedElement singleImportedElement = (SingleImportedElement)importedElement;
                    String originalName = singleImportedElement.getName();
                    String alias = singleImportedElement.getAlias();
                    String string = resolvedName = StringUtils.isBlank((String)alias) ? originalName : alias;
                    if (elementsToBeImported == null) continue;
                    elementsToBeImported.put(originalName, resolvedName);
                    continue;
                }
                if (!(importedElement instanceof StarImportedElement)) continue;
                elementsToBeImported.put("*", null);
            }
            Document moduleDocument = WeaveModulesManager.getInstance().getModule(importWithSubElements.getSource());
            if (moduleDocument == null) continue;
            EvaluationContextUtils.processModule(moduleDocument, constTypes, typeResolver, "", elementsToBeImported);
        }
        List importedModules = DFLModelHelper.getImportsModuleOnly((Document)rootDocument);
        for (ImportModuleOnly importedModule : importedModules) {
            String alias = importedModule.getAlias();
            String prefix = StringUtils.isBlank((String)alias) ? importedModule.getSource() : alias;
            constTypes.put(prefix, DFLTypeFactory.ANY);
            Document moduleDocument = WeaveModulesManager.getInstance().getModule(importedModule.getSource());
            if (moduleDocument == null) continue;
            EvaluationContextUtils.processModule(moduleDocument, constTypes, typeResolver, prefix + "::", EvaluationContextUtils.starImport());
        }
    }
}

