/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;

public class EvaluationContext {
    private IMetaDataProvider dataSenseService;
    private Stack<Map<String, IDFLType>> variables = new Stack();

    public EvaluationContext(IMetaDataProvider dataSenseService, Map<String, IDFLType> constants) {
        this.dataSenseService = dataSenseService;
        this.variables.push(constants);
    }

    public Optional<IDFLType> getVariable(String name) {
        for (Map map : this.variables) {
            if (!map.containsKey(name)) continue;
            return Optional.of((IDFLType)map.get(name));
        }
        return this.getFromDataSense(name);
    }

    private Optional<IDFLType> getFromDataSense(String variableName) {
        if ("vars".equals(variableName)) {
            return Optional.of(this.getProperties());
        }
        Optional<MetadataType> model = this.dataSenseService.getModel(variableName);
        return DFLTypeFactory.fromMetadataType(model);
    }

    public Map<String, IDFLType> getVariables() {
        Optional<IDFLType> attributes;
        Optional<IDFLType> vars;
        HashMap<String, IDFLType> variables = new HashMap<String, IDFLType>();
        for (Map map : this.variables) {
            variables.putAll(map);
        }
        Optional<IDFLType> optional = this.getFromDataSense("payload");
        if (optional.isPresent()) {
            variables.put("payload", optional.get());
        }
        if ((vars = this.getFromDataSense("vars")).isPresent()) {
            variables.put("vars", vars.get());
        }
        if ((attributes = this.getFromDataSense("attributes")).isPresent()) {
            variables.put("attributes", attributes.get());
        }
        Map<String, IDFLType> globalBindings = this.getGlobalBindingsFromDataSense();
        variables.putAll(globalBindings);
        Map<String, IDFLType> functionBindings = this.getFunctionBindingsFromDataSense();
        variables.putAll(functionBindings);
        variables.put("error", DFLTypeFactory.ERROR);
        return variables;
    }

    private Map<String, IDFLType> getFunctionBindingsFromDataSense() {
        return this.getBindingsFromDataSense(this.dataSenseService.getFunctionBindings());
    }

    private Map<String, IDFLType> getGlobalBindingsFromDataSense() {
        return this.getBindingsFromDataSense(this.dataSenseService.getGlobalBindings());
    }

    private Map<String, IDFLType> getBindingsFromDataSense(Map<String, MetadataType> globalBindings) {
        HashMap<String, IDFLType> types = new HashMap<String, IDFLType>();
        for (Map.Entry<String, MetadataType> binding : globalBindings.entrySet()) {
            types.put(binding.getKey(), DFLTypeFactory.fromMetadataType(binding.getValue()));
        }
        return types;
    }

    private IDFLType getProperties() {
        ObjectType variables = this.dataSenseService.getMetadata().getVariables();
        return DFLTypeFactory.fromMetaDataProperties(variables);
    }

    public void startFrame() {
        this.variables.push(new HashMap());
    }

    public void endFrame() {
        this.variables.pop();
    }

    public void setValue(String variableName, IDFLType value) {
        this.variables.peek().put(variableName, value);
    }

    public IMetaDataProvider getDataSenseService() {
        return this.dataSenseService;
    }
}

