/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.mule.tooling.dfl.dFL.ArrayType;
import org.mule.tooling.dfl.dFL.BasicTypeExpression;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.IntersectionTypeExpression;
import org.mule.tooling.dfl.dFL.Schema;
import org.mule.tooling.dfl.dFL.SchemaElement;
import org.mule.tooling.dfl.dFL.TypeDirective;
import org.mule.tooling.dfl.dFL.TypeExpression;
import org.mule.tooling.dfl.dFL.TypeReference;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLArrayType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.util.DFLModelHelper;

public class DFLTypeSystem {
    private Map<String, IDFLType> types = new HashMap<String, IDFLType>();

    private DFLTypeSystem() {
        this.registerType(DFLTypeFactory.STRING);
        this.registerType(DFLTypeFactory.NUMBER);
        this.registerType(DFLTypeFactory.BOOLEAN);
        this.registerType(DFLTypeFactory.DATE);
        this.registerType(DFLTypeFactory.DATETIME);
        this.registerType(DFLTypeFactory.TIME);
        this.registerType(DFLTypeFactory.PERIOD);
        this.registerType(DFLTypeFactory.LOCALDATETIME);
        this.registerType(DFLTypeFactory.LOCALTIME);
        this.registerType(DFLTypeFactory.URI);
        this.registerType(DFLTypeFactory.BINARY);
        this.registerType(DFLTypeFactory.RANGE);
        this.registerType(DFLTypeFactory.REGEX);
        this.registerType(DFLTypeFactory.NULL);
        this.registerType(DFLTypeFactory.ANY);
        this.registerType(DFLTypeFactory.ANY_OBJECT);
        this.registerType(DFLTypeFactory.ANY_ARRAY);
        this.registerType(DFLTypeFactory.ANY_LAMBDA);
        this.registerType(DFLTypeFactory.TYPE);
        this.registerType(DFLTypeFactory.ITERATOR);
        this.registerType(DFLTypeFactory.CDATA);
    }

    public DFLTypeSystem registerType(IDFLType type) {
        this.types.put(type.getName(), type);
        return this;
    }

    public Collection<IDFLType> types() {
        return this.types.values();
    }

    public Optional<IDFLType> lookupType(String name) {
        return Optional.ofNullable(this.types.get(name));
    }

    public static DFLTypeSystem create(Document document) {
        List typeDirectives = DFLModelHelper.getTypeDirectives((Document)document);
        DFLTypeSystem dflTypeSystem = new DFLTypeSystem();
        for (TypeDirective typeDirective : typeDirectives) {
            String typeName = typeDirective.getName();
            TypeExpression unionType = typeDirective.getType();
            DFLTypeSystem.createType(typeName, unionType, dflTypeSystem);
        }
        return dflTypeSystem;
    }

    private static IDFLType createType(String typeName, TypeExpression unionType, DFLTypeSystem dflTypeSystem) {
        IDFLType returnType = DFLTypeFactory.UNKNOWN;
        if (unionType != null && unionType.getTypes() != null && unionType.getTypes().size() == 1) {
            BasicTypeExpression typeExpression = (BasicTypeExpression)((IntersectionTypeExpression)unionType.getTypes().get(0)).getTypes().get(0);
            if (typeExpression instanceof TypeReference) {
                TypeReference type = (TypeReference)typeExpression;
                Schema properties = type.getSchema();
                Map<String, Object> propertiesName = DFLTypeSystem.loadSchemaToMap(properties);
                IDFLType extendFrom = DFLTypeFactory.extendFrom(dflTypeSystem, type.getFullQualifiedName(), typeName, propertiesName);
                dflTypeSystem.registerType(extendFrom);
                returnType = extendFrom;
            } else if (typeExpression instanceof ArrayType) {
                ArrayType type = (ArrayType)typeExpression;
                Schema schema = type.getSchema();
                if (schema != null) {
                    IDFLArrayType array = DFLTypeFactory.arrayOf(DFLTypeSystem.createType(null, type.getTypeExpression(), dflTypeSystem), typeName, true);
                    returnType = array;
                } else {
                    IDFLArrayType array = DFLTypeFactory.arrayOf(DFLTypeSystem.createType(null, type.getTypeExpression(), dflTypeSystem), typeName, true);
                    dflTypeSystem.registerType(array);
                    returnType = array;
                }
            }
        }
        return returnType;
    }

    public static Map<String, Object> loadSchemaToMap(Schema properties) {
        EList listOfProperties;
        HashMap<String, Object> propertiesName = new HashMap<String, Object>();
        if (properties != null && (listOfProperties = properties.getElements()) != null) {
            for (SchemaElement property : listOfProperties) {
                propertiesName.put(property.getName(), DFLModelHelper.getLiteralValue((Expression)property.getValue()));
            }
        }
        return propertiesName;
    }
}

