/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.evaluator;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.mule.tooling.client.ToolingPropagationInfo;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.mel.partitioner.DefaultEvaluatorResult;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtension;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.EvaluatorResult;
import org.mule.tooling.core.mel.partitioner.EvaluatorValidator;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.dfl.ui.contentassist.evaluator.DwelCompletionProcessor;
import org.mule.tooling.dfl.ui.contentassist.evaluator.DwelModuleInjector;
import org.mule.tooling.dfl.ui.datasense.IDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.MetadataHelper;
import org.mule.tooling.dfl.ui.ls.DataWeaveLanguageService;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.weave.v2.editor.ValidationMessages;

public class DwelEvaluatorExtension
implements EvaluatorExtension {
    private static final char EXPRESSION_TERMINATION_CHAR = ']';
    private static final int MAX_WAIT_FOR_VALIDATION_MILLIS = 500;
    private static final String DW_FILE_URI_START = "${file::";
    private static final String DW_FILE_URI_END = "}";
    private static final String DW_ERROR_READING_FILE = "There was an error reading the script.";
    private static final String DW_FILE_NOT_FOUND_ERROR = "The DWL script could not be found. Note that the file path should be relative to the resources folder.";

    public String getName() {
        return "dw";
    }

    public EvaluatorResult partition(String text) {
        char[] charArray = text.toCharArray();
        int length = charArray.length;
        int bracketLevel = 0;
        boolean insideString = false;
        char stringChar = '\u0000';
        StringBuilder expressionBuilder = new StringBuilder();
        int i = 0;
        while (i < length) {
            char character = charArray[i];
            if (character == ']' && bracketLevel == 0) break;
            expressionBuilder.append(character);
            if (character == '\'' || character == '\"') {
                if (insideString) {
                    if (character == stringChar) {
                        insideString = false;
                    }
                } else {
                    insideString = true;
                    stringChar = character;
                }
            } else if (!insideString) {
                if (character == '[') {
                    ++bracketLevel;
                } else if (character == ']' && bracketLevel > 0) {
                    --bracketLevel;
                }
            }
            ++i;
        }
        String expression = expressionBuilder.toString();
        return new DefaultEvaluatorResult(expression);
    }

    public IContentAssistProcessor getContentAssistProcessor(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        return new DwelCompletionProcessor(configurationRef);
    }

    public EvaluatorValidator getValidator(final EvaluatorExtensionConfiguration configuration) {
        return new EvaluatorValidator(){
            IStatus result = Status.OK_STATUS;

            public IStatus validate(String script) {
                IMuleProject project = configuration.getProject();
                if (project != null) {
                    Document document = this.processScript(script, project);
                    if (document == null) {
                        return this.result;
                    }
                    Optional<Object> messages = Optional.empty();
                    MuleConfiguration muleConfiguration = configuration.getMuleConfiguration();
                    IMessageFlowNode node = configuration.getNode();
                    if (muleConfiguration != null && node != null) {
                        CompletableFuture<PropagationInfo> propagationMetadata = MetadataHelper.getPropagationMetadata(project, muleConfiguration, (MessageFlowEntity)node);
                        try {
                            PropagationInfo propagationInfo = propagationMetadata.get(500L, TimeUnit.MILLISECONDS);
                            messages = Optional.of(DataWeaveLanguageService.getInstance(project).validateScript((IDocument)document, IDataSenseProvider.create(propagationInfo), false));
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException exception) {
                            messages = this.validateWithoutPropagation(project, document);
                        }
                    } else {
                        messages = this.validateWithoutPropagation(project, document);
                    }
                    if (messages.isPresent() && ((ValidationMessages)messages.get()).errorMessage().length > 0) {
                        this.result = new Status(4, "org.mule.tooling.dfl.DFL", ((ValidationMessages)messages.get()).errorMessage()[0].message().message());
                    }
                }
                return this.result;
            }

            private Optional<ValidationMessages> validateWithoutPropagation(IMuleProject project, Document document) {
                return Optional.of(DataWeaveLanguageService.getInstance(project).validateScript((IDocument)document, IDataSenseProvider.create(ToolingPropagationInfo.PropagationInfoBuilder.DEFAULT), true));
            }

            private Document processScript(String script, IMuleProject project) {
                if (this.isDwFileUri(script)) {
                    String fileName = StringUtils.substringBetween((String)script, (String)DwelEvaluatorExtension.DW_FILE_URI_START, (String)DwelEvaluatorExtension.DW_FILE_URI_END);
                    String fileContents = this.getContentsAsString(fileName, project);
                    if (fileContents != null) {
                        return new Document(fileContents);
                    }
                    return null;
                }
                return new Document(script);
            }

            private String getContentsAsString(String fileName, IMuleProject project) {
                IFile file;
                block3: {
                    file = project.getMuleResourcesFolder().getFile(fileName);
                    if (file.exists()) break block3;
                    this.result = new Status(4, "org.mule.tooling.dfl.DFL", DwelEvaluatorExtension.DW_FILE_NOT_FOUND_ERROR);
                    return null;
                }
                try {
                    return MuleResourceUtils.readContentsUsingDefaultCharset((IStorage)file);
                }
                catch (IOException | CoreException throwable) {
                    this.result = new Status(4, "org.mule.tooling.dfl.DFL", DwelEvaluatorExtension.DW_ERROR_READING_FILE);
                    return null;
                }
            }

            private boolean isDwFileUri(String script) {
                return StringUtils.startsWith((String)script, (String)DwelEvaluatorExtension.DW_FILE_URI_START) && StringUtils.endsWith((String)script, (String)DwelEvaluatorExtension.DW_FILE_URI_END);
            }
        };
    }

    public DefaultDamagerRepairer getDamagerRepairer() {
        ITokenScanner tokenScanner = (ITokenScanner)DwelModuleInjector.dflInjector().getInstance(ITokenScanner.class);
        return new DwelDamagerRepairer(tokenScanner);
    }

    public boolean isDefaultExpressionLanguage() {
        return true;
    }

    private static final class DwelDamagerRepairer
    extends DefaultDamagerRepairer {
        private IDocument document;
        private ITypedRegion region;

        private DwelDamagerRepairer(ITokenScanner scanner) {
            super(scanner);
        }

        public void setDocument(IDocument document) {
            this.document = document;
            super.setDocument(document);
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
            super.setDocument(this.createXTextDocument());
            return super.getDamageRegion(partition, e, documentPartitioningChanged);
        }

        private IDocument createXTextDocument() {
            XtextDocument xtextDocument = (XtextDocument)DwelModuleInjector.dflInjector().getInstance(XtextDocument.class);
            xtextDocument.set(this.document.get());
            return xtextDocument;
        }

        public void createPresentation(TextPresentation presentation, ITypedRegion region) {
            if (region.getLength() > 0) {
                this.region = region;
                super.setDocument(this.createXTextDocument());
                this.doCreatePresentation(presentation, region);
            }
        }

        protected void doCreatePresentation(TextPresentation presentation, ITypedRegion region) {
            IToken token;
            if (this.fScanner == null) {
                this.addRange(presentation, region.getOffset(), region.getLength(), this.fDefaultTextAttribute);
                return;
            }
            int lastStart = region.getOffset();
            int length = 0;
            boolean firstToken = true;
            IToken lastToken = Token.UNDEFINED;
            TextAttribute lastAttribute = this.getTokenTextAttribute(lastToken);
            this.fScanner.setRange(this.fDocument, lastStart, region.getLength());
            while (!(token = this.fScanner.nextToken()).isEOF()) {
                if (this.fScanner.getTokenOffset() < region.getOffset() || this.fScanner.getTokenOffset() > region.getOffset() + region.getLength()) continue;
                TextAttribute attribute = this.getTokenTextAttribute(token);
                if (lastAttribute != null && lastAttribute.equals((Object)attribute)) {
                    length += this.fScanner.getTokenLength();
                    firstToken = false;
                    continue;
                }
                if (!firstToken) {
                    this.addRange(presentation, lastStart, length, lastAttribute);
                }
                firstToken = false;
                lastToken = token;
                lastAttribute = attribute;
                lastStart = this.fScanner.getTokenOffset();
                length = this.fScanner.getTokenLength();
            }
            this.addRange(presentation, lastStart, length, lastAttribute);
        }

        protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
            length = (offset = Math.max(offset, this.region.getOffset())) + length >= this.region.getOffset() + this.region.getLength() ? this.region.getLength() - (offset - this.region.getOffset()) : length;
            super.addRange(presentation, offset, length, attr);
        }
    }
}

