/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist.evaluator;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.dfl.ui.datasense.DataSenseHolder;
import org.mule.tooling.dfl.ui.datasense.DefaultDataSenseProvider;
import org.mule.tooling.dfl.ui.datasense.DwMetadataProvider;
import org.mule.tooling.dfl.ui.embedded.editor.DFLEmbeddedEditorResourceProvider;
import org.mule.tooling.dfl.ui.ls.DataWeaveCompletionService;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.properties.views.MulePropertiesView;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.definition.MessageRowType;
import org.mule.weave.v2.completion.SuggestionResult;

public class DwelCompletionProcessor
implements IContentAssistProcessor {
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private static final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'.', ',', ' '};
    private static final ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private final IObjectRef<EvaluatorExtensionConfiguration> configurationRef;
    private DataWeaveCompletionService dataWeaveCompletionService;

    public DwelCompletionProcessor(IObjectRef<EvaluatorExtensionConfiguration> configurationRef) {
        this.configurationRef = configurationRef;
        this.dataWeaveCompletionService = new DataWeaveCompletionService();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        try {
            int documentShift;
            Document subDocument;
            int offsetInsideNewDocument;
            ITypedRegion workingPartition;
            ITypedRegion evaluatorPartition = document.getPartition(offset);
            if ("org.eclipse.wst.xml.XML_DEFAULT".equals(evaluatorPartition.getType())) {
                String text = document.get();
                int expressionOffset = text.substring(0, offset).lastIndexOf("#[") + "#[".length();
                int lengthToAnalyze = offset - expressionOffset;
                workingPartition = new TypedRegion(expressionOffset, lengthToAnalyze, "org.eclipse.wst.xml.XML_DEFAULT");
            } else {
                workingPartition = evaluatorPartition;
            }
            if ("org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EXPRESSION_BRACKETS_CONTENT_TYPE".equals(workingPartition.getType())) {
                if (offset != workingPartition.getLength() + workingPartition.getOffset()) return NO_COMPLETIONS;
                offsetInsideNewDocument = 0;
                subDocument = new Document("");
                documentShift = workingPartition.getLength() + workingPartition.getOffset();
            } else {
                documentShift = evaluatorPartition.getOffset();
                offsetInsideNewDocument = offset - documentShift;
                String subDocumentContent = document.get(evaluatorPartition.getOffset(), evaluatorPartition.getLength());
                subDocument = new Document(subDocumentContent);
            }
            URI uri = DFLEmbeddedEditorResourceProvider.createURI("Mapping_", "dwl");
            this.initializeDataSenseHolderIfNecessary(uri);
            SuggestionResult suggestions = this.dataWeaveCompletionService.getSuggestions(uri, (IDocument)subDocument, offsetInsideNewDocument);
            return this.dataWeaveCompletionService.toCompletionItem(document, offsetInsideNewDocument, documentShift, suggestions).toArray(new ICompletionProposal[0]);
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error While Building AutoComplete", (Throwable)e);
            return NO_COMPLETIONS;
        }
    }

    private void initializeDataSenseHolderIfNecessary(URI uri) {
        Optional viewIfPresent = MulePropertiesView.getViewIfPresent();
        if (viewIfPresent.isPresent()) {
            EvaluatorExtensionConfiguration evaluatorCompletionConfiguration = (EvaluatorExtensionConfiguration)this.configurationRef.get();
            IMuleProject project = evaluatorCompletionConfiguration.getProject();
            IMessageFlowNode node = evaluatorCompletionConfiguration.getNode();
            Optional maybeDataSenseInfoProvider = ((MulePropertiesView)viewIfPresent.get()).getDataSenseInfoProvider();
            if (node != null && maybeDataSenseInfoProvider.isPresent()) {
                DwMetadataProvider inputMetadataProvider = DwMetadataProvider.createInputMetaDataProvider(project, (IMessageFlowEntity)node, (IPropagationInfoProvider)maybeDataSenseInfoProvider.get());
                DwMetadataProvider outputMetadataProvider = DwMetadataProvider.createOutputMetaDataProvider(project, node, (IPropagationInfoProvider)maybeDataSenseInfoProvider.get(), MessageRowType.OUTPUT_PAYLOAD);
                DataSenseHolder.setContext(uri.toString(), new DefaultDataSenseProvider(inputMetadataProvider, outputMetadataProvider), project);
            }
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return "Could not suggest DW proposals for the current context";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

