/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist;

import org.apache.commons.lang.StringUtils;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;

public class SubstringMatcher
extends PrefixMatcher {
    private int offset;

    public boolean isCandidateMatchingPrefix(String name, String prefix) {
        name = name.replaceAll("%TAG_LABEL%", "");
        String lastSegment = this.getLastSegment(name);
        return StringUtils.containsIgnoreCase((String)lastSegment, (String)prefix);
    }

    private String getLastSegment(String str) {
        this.offset = 0;
        SegmentProcessor processor = new DefaultState(this.offset, str);
        while (this.offset < str.length()) {
            processor = processor.process();
            ++this.offset;
        }
        String lastSegment = processor.getLastSegment();
        return lastSegment;
    }

    private class DefaultState
    implements SegmentProcessor {
        private int lastSegmentOffset;
        private String text;

        public DefaultState(int currentOffset, String text) {
            this.lastSegmentOffset = currentOffset;
            this.text = text;
        }

        @Override
        public SegmentProcessor process() {
            char c = this.text.charAt(SubstringMatcher.this.offset);
            switch (c) {
                case '\"': 
                case '\'': {
                    return new QuotedState(c, SubstringMatcher.this.offset + 1, this.text);
                }
                case '.': {
                    this.lastSegmentOffset = SubstringMatcher.this.offset;
                    break;
                }
            }
            return this;
        }

        @Override
        public int getLastSegmentOffset() {
            return this.lastSegmentOffset;
        }

        @Override
        public String getLastSegment() {
            return this.text.substring(this.lastSegmentOffset);
        }
    }

    private class QuotedState
    implements SegmentProcessor {
        private final char quoteChar;
        private int quoteBeginOffset;
        private String text;

        public QuotedState(char quoteChar, int currentOffset, String text) {
            this.quoteChar = quoteChar;
            this.quoteBeginOffset = currentOffset;
            this.text = text;
        }

        @Override
        public SegmentProcessor process() {
            if (this.text.charAt(SubstringMatcher.this.offset) == this.quoteChar) {
                boolean hasPreviousChar = SubstringMatcher.this.offset > 0;
                char previousChar = this.text.charAt(SubstringMatcher.this.offset - 1);
                if (hasPreviousChar && previousChar != '\\') {
                    boolean isLastChar;
                    boolean bl = isLastChar = SubstringMatcher.this.offset == this.text.length() - 1;
                    if (isLastChar) {
                        return this;
                    }
                    return new DefaultState(SubstringMatcher.this.offset + 1, this.text);
                }
            }
            return this;
        }

        @Override
        public int getLastSegmentOffset() {
            return this.quoteBeginOffset;
        }

        @Override
        public String getLastSegment() {
            return this.text.substring(this.quoteBeginOffset, this.text.length() - 1);
        }
    }

    private static interface SegmentProcessor {
        public SegmentProcessor process();

        public int getLastSegmentOffset();

        public String getLastSegment();
    }
}

