/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledString;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.dFL.DeclaredNamespace;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.NamespaceDirective;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.ui.contentassist.NamespaceDirectivesFinder;
import org.mule.tooling.dfl.ui.contentassist.OutputTypeResolver;
import org.mule.tooling.dfl.ui.contentassist.Stylers;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.dfl.util.DFLModelHelper;

public final class ProposalHelper {
    public static final NamespaceDirectivesFinder NAMESPACE_FINDER = new NamespaceDirectivesFinder();
    public static final OutputTypeResolver OUTPUT_TYPE_RESOLVER = new OutputTypeResolver();

    private ProposalHelper() {
    }

    public static String processField(IDFLField field) {
        QName fieldName = field.getName();
        String nameWithPrefix = ProposalHelper.getNameWithNSPrefix(fieldName);
        return nameWithPrefix + " : " + String.valueOf(field.getType());
    }

    public static String getNameWithNSPrefix(QName name) {
        String localPart = ScaffoldingHelper.adjustWithQuotes(name.getLocalPart());
        return StringUtils.isNotBlank((String)name.getPrefix()) ? name.getPrefix() + "#" + localPart : localPart;
    }

    public static StyledString getStyledNameWithNSPrefix(QName name) {
        String prefix = name.getPrefix();
        String localPart = name.getLocalPart();
        if (StringUtils.isNotBlank((String)prefix)) {
            return new StyledString(prefix + "#", Stylers.DFL_NAMESPACE_STYLER).append(localPart);
        }
        return new StyledString(localPart);
    }

    public static QName getNameWithAdjustedPrefix(QName fieldName, List<NamespaceDirective> namespaces) {
        for (NamespaceDirective namespace : namespaces) {
            if (!namespace.getValue().equals(fieldName.getNamespaceURI())) continue;
            return new QName(fieldName.getNamespaceURI(), fieldName.getLocalPart(), namespace.getName());
        }
        return fieldName;
    }

    public static List<QName> getCurrentFields(EObject model) {
        ObjectPattern pattern;
        ArrayList<QName> filterFields = new ArrayList<QName>();
        if (model instanceof MultipleKeyValuePairObj && (pattern = ((MultipleKeyValuePairObj)model).getPattern()) instanceof ObjectElements) {
            EList elements = ((ObjectElements)pattern).getObjectElements();
            for (KeyValuePair keyValuePair : CoreUtils.filterByType((Iterable)elements, KeyValuePair.class)) {
                Key key = keyValuePair.getKey();
                if (!(key.getValue() instanceof StringLiteral)) continue;
                filterFields.add(DFLModelHelper.toQName((DeclaredNamespace)key.getNamespace(), (String)((StringLiteral)key.getValue()).getValue()));
            }
        }
        return filterFields;
    }

    public static String removeQuotes(String text) {
        return text.replace("'", "").replace("\"", "");
    }
}

