/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist;

import com.google.common.base.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.StyledString;
import org.mule.tooling.dfl.ui.contentassist.Stylers;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;
import org.mule.tooling.dfl.ui.contentassist.model.types.DefaultDFLField;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;

public class PathSegment {
    private final QName value;
    private final IDFLField field;

    private PathSegment(QName value, IDFLField elem) {
        this.value = value;
        this.field = elem;
    }

    public static PathSegment create(QName value, IDFLField elem) {
        return new PathSegment(value, elem);
    }

    public QName getValue() {
        return this.value;
    }

    public String getLocalPart() {
        return this.value.getLocalPart();
    }

    public Optional<String> getNSPrefix() {
        String prefix = this.value.getPrefix();
        if (StringUtils.isBlank((String)prefix)) {
            return Optional.absent();
        }
        return Optional.of((Object)prefix);
    }

    public IDFLField getField() {
        return this.field;
    }

    public String getText(String prefix, String suffix, int segmentNumber) {
        StrBuilderWrapper appendable = new StrBuilderWrapper(new StringBuilder());
        StringBuilder styledString = this.getSegmentText(appendable, prefix, suffix, segmentNumber);
        return styledString.toString();
    }

    public StyledString getStyledText(String prefix, String suffix, int segmentNumber) {
        StyledStringWrapper appendable = new StyledStringWrapper(new StyledString());
        StyledString styledString = this.getSegmentText(appendable, prefix, suffix, segmentNumber);
        return styledString;
    }

    private <T> T getSegmentText(AppendCapable<T> appendable, String prefix, String suffix, int segmentNumber) {
        if (segmentNumber > 0) {
            String selector = DefaultDFLField.isUnboundedArray(this.getField()) ? ".*" : ".";
            appendable.append(selector);
        }
        appendable.append(prefix);
        if (this.getNSPrefix().isPresent()) {
            String nsPrefix = (String)this.getNSPrefix().get() + "#";
            StyledString styledNSPrefix = new StyledString(nsPrefix, Stylers.DFL_NAMESPACE_STYLER);
            appendable.append(styledNSPrefix);
        }
        appendable.append(ScaffoldingHelper.adjustWithQuotes(this.getLocalPart()));
        appendable.append(suffix);
        return appendable.value();
    }

    public String toString() {
        return "PathSegment [value=" + String.valueOf(this.value) + "]";
    }

    static interface AppendCapable<T> {
        public AppendCapable<T> append(Object var1);

        public T value();
    }

    public static class StrBuilderWrapper
    implements AppendCapable<StringBuilder> {
        private StringBuilder strBuilder;

        public StrBuilderWrapper(StringBuilder strBuilder) {
            this.strBuilder = strBuilder;
        }

        @Override
        public AppendCapable<StringBuilder> append(Object appendable) {
            this.strBuilder.append(appendable);
            return this;
        }

        @Override
        public StringBuilder value() {
            return this.strBuilder;
        }
    }

    public static class StyledStringWrapper
    implements AppendCapable<StyledString> {
        private StyledString styledString;

        public StyledStringWrapper(StyledString styledString) {
            this.styledString = styledString;
        }

        @Override
        public AppendCapable<StyledString> append(Object appendable) {
            if (appendable instanceof StyledString) {
                this.styledString.append((StyledString)appendable);
            } else if (appendable instanceof String) {
                this.styledString.append((String)appendable);
            } else if (appendable instanceof Character) {
                this.styledString.append(((Character)appendable).charValue());
            } else {
                throw new RuntimeException("Error while trying to append path segment components.");
            }
            return this;
        }

        @Override
        public StyledString value() {
            return this.styledString;
        }
    }
}

