/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.mule.tooling.dfl.dFL.Array;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.Body;
import org.mule.tooling.dfl.dFL.DeclaredNamespace;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyExpression;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.ui.contentassist.model.DFLTypeHelper;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLArrayType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLObjectType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.dfl.util.DFLModelHelper;

public class OutputTypeResolver {
    private final PolymorphicDispatcher<List<PathSegment>> dispatcher = new PolymorphicDispatcher("getData", 1, 1, Collections.singletonList(this), (PolymorphicDispatcher.ErrorHandler)new Handler());

    public List<PathSegment> getPath(EObject model) {
        return (List)this.dispatcher.invoke(new Object[]{model});
    }

    public IDFLType resolve(EObject model, IDFLType outputType) {
        List<PathSegment> path = this.getPath(model);
        IDFLType currentType = outputType;
        CurrentTypeResolver visitor = new CurrentTypeResolver();
        for (PathSegment segment : path) {
            visitor.setCurrentType(currentType);
            segment.accept(visitor);
            currentType = visitor.getCurrentType();
            if (currentType != DFLTypeFactory.UNKNOWN) continue;
            return DFLTypeFactory.UNKNOWN;
        }
        return currentType;
    }

    private IDFLType resolveType(IDFLType currentType, QName qName) {
        IDFLObjectType object = currentType.asObjectType();
        Optional<IDFLField> field = DFLTypeHelper.findField(object, qName);
        currentType = field.isPresent() ? field.get().getType() : DFLTypeFactory.UNKNOWN;
        return currentType;
    }

    public Optional<IDFLField> resolveField(EObject model, IDFLType outputType) {
        List<PathSegment> path = this.getPath(model);
        IDFLType currentType = outputType;
        CurrentTypeResolver visitor = new CurrentTypeResolver();
        int i = 0;
        for (PathSegment segment : path) {
            boolean isLastSegment;
            boolean bl = isLastSegment = i == path.size() - 1;
            if (isLastSegment && segment instanceof QNamePathSegment) {
                QName qName = ((QNamePathSegment)segment).getQName();
                if (currentType.isObject()) {
                    return DFLTypeHelper.findField(currentType.asObjectType(), qName);
                }
                if (currentType.isArray()) {
                    IDFLArrayType arrayType = currentType.asArrayType();
                    return DFLTypeHelper.findField(arrayType.getType().asObjectType(), qName);
                }
            }
            visitor.setCurrentType(currentType);
            segment.accept(visitor);
            currentType = visitor.getCurrentType();
            if (currentType == DFLTypeFactory.UNKNOWN) {
                return Optional.empty();
            }
            ++i;
        }
        return Optional.empty();
    }

    public List<PathSegment> getData(MultipleKeyValuePairObj model) {
        ArrayList<PathSegment> response = new ArrayList<PathSegment>((Collection)this.dispatcher.invoke(new Object[]{model.eContainer()}));
        return response;
    }

    public List<PathSegment> getData(KeyValuePair model) {
        ArrayList<PathSegment> response = new ArrayList<PathSegment>((Collection)this.dispatcher.invoke(new Object[]{model.eContainer()}));
        this.addKey(model.getKey(), response);
        return response;
    }

    public List<PathSegment> getData(Array model) {
        ArrayList<PathSegment> response = new ArrayList<PathSegment>((Collection)this.dispatcher.invoke(new Object[]{model.eContainer()}));
        response.add(new ArrayPathSegment());
        return response;
    }

    public List<PathSegment> getData(BinaryFunction model) {
        if (DflFactoryUtils.isFunctionNamed((EObject)model, "map")) {
            EObject container = model.eContainer();
            ArrayList<PathSegment> response = new ArrayList<PathSegment>((Collection)this.dispatcher.invoke(new Object[]{container}));
            response.add(container instanceof KeyValuePair ? new ArrayPathSegment() : new SwappableXMLArrayPathSegment());
            return response;
        }
        return Collections.emptyList();
    }

    private void addKey(Key key, List<PathSegment> response) {
        KeyExpression keyExpression = key.getValue();
        if (keyExpression instanceof StringLiteral) {
            QName qName = DFLModelHelper.toQName((DeclaredNamespace)key.getNamespace(), (String)((StringLiteral)keyExpression).getValue());
            if (!this.checkSwappableXMLArrayAsLastSegment(response)) {
                response.add(new QNamePathSegment(qName));
            } else {
                int size = response.size();
                int index = size - 1;
                response.add(index, new QNamePathSegment(qName));
                response.set(size, new XMLArrayPathSegment());
            }
        }
    }

    private boolean checkSwappableXMLArrayAsLastSegment(List<PathSegment> response) {
        if (!response.isEmpty()) {
            PathSegment lastSegment = response.get(response.size() - 1);
            return lastSegment instanceof SwappableXMLArrayPathSegment;
        }
        return false;
    }

    private static class ArrayPathSegment
    implements PathSegment {
        private ArrayPathSegment() {
        }

        @Override
        public void accept(PathSegmentVisitor visitor) {
            visitor.visitArray(this);
        }
    }

    private class CurrentTypeResolver
    implements PathSegmentVisitor {
        IDFLType currentType;

        private CurrentTypeResolver() {
        }

        @Override
        public void visitQName(QNamePathSegment segment) {
            if (DFLTypeFactory.ANY_OBJECT.isAssignableFrom(this.currentType)) {
                this.currentType = OutputTypeResolver.this.resolveType(this.currentType, segment.getQName());
            }
        }

        @Override
        public void visitArray(ArrayPathSegment segment) {
            IDFLType type = this.currentType.asArrayType().getType();
            if (DFLTypeFactory.ANY_OBJECT.isAssignableFrom(type) || DFLTypeFactory.ANY_ARRAY.isAssignableFrom(type)) {
                this.currentType = type;
            }
        }

        @Override
        public void visitArray(XMLArrayPathSegment segment) {
            IDFLType type;
            if (this.currentType.isArray() && (DFLTypeFactory.ANY_OBJECT.isAssignableFrom(type = this.currentType.asArrayType().getType()) || DFLTypeFactory.ANY_ARRAY.isAssignableFrom(type))) {
                this.currentType = type;
            }
        }

        public IDFLType getCurrentType() {
            return this.currentType;
        }

        public void setCurrentType(IDFLType currentType) {
            this.currentType = currentType;
        }
    }

    private final class Handler
    implements PolymorphicDispatcher.ErrorHandler<List<PathSegment>> {
        private Handler() {
        }

        public List<PathSegment> handle(Object[] params, Throwable throwable) {
            EObject eContainer = ((EObject)params[0]).eContainer();
            if (eContainer != null && !(eContainer instanceof Body)) {
                return (List)OutputTypeResolver.this.dispatcher.invoke(new Object[]{eContainer});
            }
            return Collections.emptyList();
        }
    }

    private static interface PathSegment {
        public void accept(PathSegmentVisitor var1);
    }

    private static interface PathSegmentVisitor {
        public void visitQName(QNamePathSegment var1);

        public void visitArray(ArrayPathSegment var1);

        public void visitArray(XMLArrayPathSegment var1);
    }

    private static class QNamePathSegment
    implements PathSegment {
        private QName qName;

        public QNamePathSegment(QName qName) {
            this.qName = qName;
        }

        @Override
        public void accept(PathSegmentVisitor visitor) {
            visitor.visitQName(this);
        }

        public QName getQName() {
            return this.qName;
        }
    }

    private static class SwappableXMLArrayPathSegment
    extends XMLArrayPathSegment {
        private SwappableXMLArrayPathSegment() {
        }
    }

    private static class XMLArrayPathSegment
    implements PathSegment {
        private XMLArrayPathSegment() {
        }

        @Override
        public void accept(PathSegmentVisitor visitor) {
            visitor.visitArray(this);
        }
    }
}

