/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist;

import com.google.common.collect.Lists;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.StyledString;
import org.mule.tooling.dfl.dFL.NamespaceDirective;
import org.mule.tooling.dfl.ui.contentassist.FieldDelegate;
import org.mule.tooling.dfl.ui.contentassist.PathSegment;
import org.mule.tooling.dfl.ui.contentassist.ProposalHelper;
import org.mule.tooling.dfl.ui.contentassist.Stylers;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;

public class FieldWithPath
extends FieldDelegate {
    private final List<PathSegment> path;
    private final List<NamespaceDirective> namespaces;
    private final int depth;

    public FieldWithPath(IDFLField field, List<PathSegment> path, List<NamespaceDirective> namespaces, int depth) {
        super(field);
        this.path = path;
        this.namespaces = namespaces;
        this.depth = depth;
    }

    public List<PathSegment> getPath() {
        return Lists.newArrayList(this.path);
    }

    public String toString() {
        return this.getNameString();
    }

    public String getNameString() {
        return this.getNameString("", "");
    }

    public String getNameStringWithPrefix(String prefix) {
        return this.getNameString(prefix, "");
    }

    public String getNameString(String prefix, String suffix) {
        QName qnameWithAdjustedPrefix = ProposalHelper.getNameWithAdjustedPrefix(this.getField().getName(), this.namespaces);
        PathSegment segment = PathSegment.create(qnameWithAdjustedPrefix, this.getField());
        StringBuilder stringBuilder = this.getPathString(this.path);
        stringBuilder.append(segment.getText(prefix, suffix, this.path.size()));
        return stringBuilder.toString();
    }

    private StringBuilder getPathString(List<PathSegment> path) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < path.size()) {
            PathSegment segment = path.get(i);
            stringBuilder.append(segment.getText("", "", i));
            ++i;
        }
        return stringBuilder;
    }

    public StyledString getStyledName() {
        return this.getStyledNameWithPrefix("");
    }

    public StyledString getStyledNameWithPrefix(String prefix) {
        return this.getStyledName(prefix, "");
    }

    public StyledString getStyledName(String prefix, String suffix) {
        QName qnameWithAdjustedPrefix = ProposalHelper.getNameWithAdjustedPrefix(this.getField().getName(), this.namespaces);
        String pathStr = this.getPathString(this.path).toString();
        PathSegment segment = PathSegment.create(qnameWithAdjustedPrefix, this.getField());
        if (StringUtils.isBlank((String)pathStr)) {
            StyledString styledSegment = segment.getStyledText(prefix, suffix, 0);
            return styledSegment;
        }
        StyledString styledPath = new StyledString(pathStr, Stylers.GRAY_STYLER);
        StyledString styledLastSegment = segment.getStyledText(prefix, suffix, this.path.size() + 1);
        return styledPath.append(styledLastSegment);
    }

    public int getDepth() {
        return this.depth;
    }

    public List<NamespaceDirective> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String textRepresentation(int tabulation) {
        return StringUtils.repeat((String)" ", (int)tabulation) + String.valueOf(this.getName()) + ": " + this.getType().textRepresentation(tabulation);
    }
}

