/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.dfl.dFL.DotSelector;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.NamespaceDirective;
import org.mule.tooling.dfl.dFL.Selector;
import org.mule.tooling.dfl.dFL.SelectorOrFunction;
import org.mule.tooling.dfl.dFL.ValueSelector;
import org.mule.tooling.dfl.ui.contentassist.DFLModelTypeResolver;
import org.mule.tooling.dfl.ui.contentassist.FieldDelegate;
import org.mule.tooling.dfl.ui.contentassist.FieldWithPath;
import org.mule.tooling.dfl.ui.contentassist.PathSegment;
import org.mule.tooling.dfl.ui.contentassist.ProposalHelper;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;

public class DotSelectorProposalFieldsProvider {
    public List<IDFLField> getElements(EObject currentModel, DFLModelTypeResolver typeResolver) {
        IDFLType type = typeResolver.getReturnType(currentModel);
        return this.getFields(type);
    }

    public Collection<FieldWithPath> getDescendantElements(EObject currentModel, DFLModelTypeResolver typeResolver, List<NamespaceDirective> namespaces) {
        ArrayList currentPath = Lists.newArrayList();
        LinkedList descendantsValues = Lists.newLinkedList();
        List<IDFLField> elements = this.getElements(currentModel, typeResolver);
        for (IDFLField elem : elements) {
            LinkedHashMap currentDescendantsMap = Maps.newLinkedHashMap();
            currentDescendantsMap.put(elem.getName(), new FieldWithPath(elem, currentPath, namespaces, 0));
            List<PathSegment> newPath = this.createNewPath(currentPath, elem, namespaces);
            this.addDescendantElementsRecursively(elem, currentDescendantsMap, newPath, namespaces, 1);
            descendantsValues.addAll(currentDescendantsMap.values());
        }
        return descendantsValues;
    }

    private void addDescendantElementsRecursively(IDFLField element, Map<QName, FieldWithPath> descendantsMap, List<PathSegment> currentPath, List<NamespaceDirective> namespaces, int depth) {
        for (IDFLField elem : this.getFields(element.getType())) {
            if (descendantsMap.containsKey(elem.getName())) continue;
            descendantsMap.put(elem.getName(), new FieldWithPath(elem, currentPath, namespaces, depth));
            List<PathSegment> newPath = this.createNewPath(currentPath, elem, namespaces);
            this.addDescendantElementsRecursively(elem, descendantsMap, newPath, namespaces, depth + 1);
        }
    }

    private List<PathSegment> createNewPath(List<PathSegment> currentPath, IDFLField elem, List<NamespaceDirective> namespaces) {
        QName qnameWithAdjustedPrefix = ProposalHelper.getNameWithAdjustedPrefix(elem.getName(), namespaces);
        ArrayList newPath = Lists.newArrayList(currentPath);
        newPath.add(PathSegment.create(qnameWithAdjustedPrefix, elem));
        return newPath;
    }

    public List<FieldWithPath> getDescendantAttributes(EObject currentModel, DFLModelTypeResolver typeResolver, List<NamespaceDirective> namespaces) {
        ArrayList attributes = Lists.newArrayList();
        List<IDFLField> firstLevelAttrs = this.getAttributes(currentModel, typeResolver);
        for (IDFLField firstLevelAttr : firstLevelAttrs) {
            attributes.add(new FieldWithPath(firstLevelAttr, Collections.emptyList(), namespaces, 1));
        }
        Collection<FieldWithPath> descendants = this.getDescendantElements(currentModel, typeResolver, namespaces);
        attributes.addAll(this.getAttributesWithPath(descendants));
        return attributes;
    }

    public List<FieldWithPath> getAttributesWithPath(Collection<FieldWithPath> elements) {
        ArrayList attributes = Lists.newArrayList();
        for (FieldWithPath element : elements) {
            List<FieldWithPath> elemAttributes = this.getAttributesWithPath(element);
            attributes.addAll(elemAttributes);
        }
        return attributes;
    }

    private List<FieldWithPath> getAttributesWithPath(FieldWithPath element) {
        ArrayList ret = Lists.newArrayList();
        List<IDFLField> fields = element.getAttributes();
        for (IDFLField field : fields) {
            List<PathSegment> path = element.getPath();
            QName qnameWithAdjustedPrefix = ProposalHelper.getNameWithAdjustedPrefix(element.getName(), element.getNamespaces());
            path.add(PathSegment.create(qnameWithAdjustedPrefix, field));
            ret.add(new FieldWithPath(field, path, element.getNamespaces(), element.getDepth() + 1));
        }
        return ret;
    }

    public List<IDFLField> getAttributes(EObject model, DFLModelTypeResolver typeResolver) {
        ArrayList attributes = Lists.newArrayList();
        List<IDFLField> toSelectForAttrs = this.getObjectToSelectForAttrs(model, typeResolver);
        Optional<Selector> selector = this.getSelector(model);
        for (IDFLField field : toSelectForAttrs) {
            if (!field.getName().getLocalPart().equalsIgnoreCase(((Selector)selector.get()).getName())) continue;
            attributes.addAll(field.getAttributes());
        }
        return attributes;
    }

    private Optional<Selector> getSelector(EObject currentModel) {
        if (currentModel instanceof DotSelector) {
            DotSelector selector = (DotSelector)currentModel;
            SelectorOrFunction selectorOrFunction = selector.getSelector();
            if (selectorOrFunction instanceof Selector) {
                return Optional.of((Object)((Selector)selectorOrFunction));
            }
        } else if (currentModel instanceof ValueSelector) {
            return Optional.of((Object)((ValueSelector)currentModel).getSelector());
        }
        return Optional.absent();
    }

    private List<IDFLField> getObjectToSelectForAttrs(EObject model, DFLModelTypeResolver typeResolver) {
        if (model instanceof DotSelector) {
            Expression toSelect = ((DotSelector)model).getData();
            return this.getElements((EObject)toSelect, typeResolver);
        }
        if (model instanceof ValueSelector) {
            Expression toSelect = ((ValueSelector)model).getData();
            return this.getElements((EObject)toSelect, typeResolver);
        }
        return Collections.emptyList();
    }

    private List<IDFLField> getFields(IDFLType type) {
        IDFLType arrayElemsType;
        if (type.isObject()) {
            return type.asObjectType().getFields();
        }
        if (type.isArray() && (arrayElemsType = type.asArrayType().getType()).isObject()) {
            List<IDFLField> fields = arrayElemsType.asObjectType().getFields();
            return this.getWrappedFields(fields);
        }
        return Collections.emptyList();
    }

    private List<IDFLField> getWrappedFields(List<IDFLField> fields) {
        ArrayList wrappedFields = Lists.newArrayList();
        for (IDFLField field : fields) {
            wrappedFields.add(new FieldWrapper(field));
        }
        return wrappedFields;
    }

    private static final class FieldWrapper
    extends FieldDelegate {
        public FieldWrapper(IDFLField field) {
            super(field);
        }

        @Override
        public IDFLType getType() {
            return DFLTypeFactory.arrayOf(super.getType());
        }

        public String toString() {
            return String.valueOf(this.getField());
        }
    }
}

