/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.dFL.And;
import org.mule.tooling.dfl.dFL.AnyDateLiteral;
import org.mule.tooling.dfl.dFL.AnyRegexLiteral;
import org.mule.tooling.dfl.dFL.Array;
import org.mule.tooling.dfl.dFL.ArrayElement;
import org.mule.tooling.dfl.dFL.As;
import org.mule.tooling.dfl.dFL.Attribute;
import org.mule.tooling.dfl.dFL.AttributeElement;
import org.mule.tooling.dfl.dFL.Attributes;
import org.mule.tooling.dfl.dFL.BasicTypeExpression;
import org.mule.tooling.dfl.dFL.BinaryFunction;
import org.mule.tooling.dfl.dFL.BooleanLiteral;
import org.mule.tooling.dfl.dFL.ClojureOperator;
import org.mule.tooling.dfl.dFL.ClojureOperatorOrOrExpression;
import org.mule.tooling.dfl.dFL.DeclaredNamespace;
import org.mule.tooling.dfl.dFL.Division;
import org.mule.tooling.dfl.dFL.DollarVariable;
import org.mule.tooling.dfl.dFL.DotSelector;
import org.mule.tooling.dfl.dFL.DynamicSelector;
import org.mule.tooling.dfl.dFL.EnclosedObjectElement;
import org.mule.tooling.dfl.dFL.Equal;
import org.mule.tooling.dfl.dFL.Expression;
import org.mule.tooling.dfl.dFL.FilterSelector;
import org.mule.tooling.dfl.dFL.FunctionCall;
import org.mule.tooling.dfl.dFL.FunctionCallArgs;
import org.mule.tooling.dfl.dFL.FunctionDirective;
import org.mule.tooling.dfl.dFL.FunctionParameter;
import org.mule.tooling.dfl.dFL.GreaterThan;
import org.mule.tooling.dfl.dFL.GreaterThanEqual;
import org.mule.tooling.dfl.dFL.IntegerLiteral;
import org.mule.tooling.dfl.dFL.IntersectionTypeExpression;
import org.mule.tooling.dfl.dFL.Is;
import org.mule.tooling.dfl.dFL.Key;
import org.mule.tooling.dfl.dFL.KeyValuePair;
import org.mule.tooling.dfl.dFL.LambdaLiteral;
import org.mule.tooling.dfl.dFL.LessThan;
import org.mule.tooling.dfl.dFL.LessThanEqual;
import org.mule.tooling.dfl.dFL.Minus;
import org.mule.tooling.dfl.dFL.MultipleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.Multiply;
import org.mule.tooling.dfl.dFL.NotEqual;
import org.mule.tooling.dfl.dFL.NullLiteral;
import org.mule.tooling.dfl.dFL.ObjectElements;
import org.mule.tooling.dfl.dFL.ObjectPattern;
import org.mule.tooling.dfl.dFL.ObjectSimpleType;
import org.mule.tooling.dfl.dFL.Or;
import org.mule.tooling.dfl.dFL.Plus;
import org.mule.tooling.dfl.dFL.QuotedStringLiteral;
import org.mule.tooling.dfl.dFL.RealLiteral;
import org.mule.tooling.dfl.dFL.RightShift;
import org.mule.tooling.dfl.dFL.Schema;
import org.mule.tooling.dfl.dFL.Selector;
import org.mule.tooling.dfl.dFL.SelectorOrFunction;
import org.mule.tooling.dfl.dFL.Similar;
import org.mule.tooling.dfl.dFL.SingleKeyValuePairObj;
import org.mule.tooling.dfl.dFL.StringLiteral;
import org.mule.tooling.dfl.dFL.StringSelector;
import org.mule.tooling.dfl.dFL.TypeExpression;
import org.mule.tooling.dfl.dFL.TypeReference;
import org.mule.tooling.dfl.dFL.UnaryMinus;
import org.mule.tooling.dfl.dFL.ValueSelector;
import org.mule.tooling.dfl.dFL.VariableReference;
import org.mule.tooling.dfl.dFL.util.DFLSwitch;
import org.mule.tooling.dfl.ui.contentassist.DFLModelTypeResolver;
import org.mule.tooling.dfl.ui.contentassist.DotSelectorProposalFieldsProvider;
import org.mule.tooling.dfl.ui.contentassist.model.DFLTypeSystem;
import org.mule.tooling.dfl.ui.contentassist.model.EvaluationContext;
import org.mule.tooling.dfl.ui.contentassist.model.EvaluationContextUtils;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLArrayType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLField;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLObjectType;
import org.mule.tooling.dfl.ui.contentassist.model.IDFLType;
import org.mule.tooling.dfl.ui.contentassist.model.types.DFLTypeFactory;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.AdditionOperationDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.AndOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.AppendOperationDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.ContainsOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.DivisionOperationDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.EndsWithOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.FilterOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.GroupByOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.LowerOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.MapObjectOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.MapOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.MultiplyOperationDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.OrOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.OrderByOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.PluckObjectOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.ReduceOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.RightShiftOperationDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.SizeOfOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.SplitByOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.StartsWithOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.SubtractionOperationDescription;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.ToOperationDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.TrimOperatorDescriptor;
import org.mule.tooling.dfl.ui.contentassist.operators.impl.UpperOperatorDescriptor;
import org.mule.tooling.dfl.ui.graphical.view2code.generation.DflFactoryUtils;
import org.mule.tooling.dfl.ui.input.IMetaDataProvider;
import org.mule.tooling.dfl.util.DFLModelHelper;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.utils.Pair;

public class DFLModelTypeResolverImpl
extends DFLSwitch<IDFLType>
implements DFLModelTypeResolver {
    private IMuleProject project;
    private DFLTypeSystem typeSystem;
    private EvaluationContext context;

    private DFLModelTypeResolverImpl(EvaluationContext context, IMuleProject project) {
        this.context = context;
        this.project = project;
    }

    public static DFLModelTypeResolverImpl create(EvaluationContext context) {
        return new DFLModelTypeResolverImpl(context, null);
    }

    public static DFLModelTypeResolverImpl create(EObject currentModel, IMetaDataProvider inputMetadata, IMuleProject project) {
        Map<String, IDFLType> constTypes = EvaluationContextUtils.createVariableContext(currentModel, inputMetadata);
        return new DFLModelTypeResolverImpl(EvaluationContextUtils.newContext(constTypes, inputMetadata), project);
    }

    public static DFLModelTypeResolverImpl create(EObject currentModel, IMetaDataProvider inputMetadata) {
        Map<String, IDFLType> constTypes = EvaluationContextUtils.createVariableContext(currentModel, inputMetadata);
        return new DFLModelTypeResolverImpl(EvaluationContextUtils.newContext(constTypes, inputMetadata), null);
    }

    public IDFLType caseMultipleKeyValuePairObj(MultipleKeyValuePairObj object) {
        ArrayList<IDFLField> fields = new ArrayList<IDFLField>();
        ObjectPattern pattern = object.getPattern();
        if (pattern instanceof ObjectElements) {
            for (KeyValuePair content : CoreUtils.filterByType((Iterable)pattern.eContents(), KeyValuePair.class)) {
                Optional<IDFLField> field = this.toField(content);
                if (!field.isPresent()) continue;
                fields.add(field.get());
            }
        }
        return DFLTypeFactory.objectWith(fields);
    }

    public IDFLType caseEnclosedObjectElement(EnclosedObjectElement object) {
        if (object.getValue() == null && object.getAttributes() == null && object.getCondition() == null) {
            this.doSwitch((EObject)object.getExpression());
        } else if (object.getExpression() != null && object.getCondition() != null && object.getValue() == null) {
            this.doSwitch((EObject)object.getExpression());
        }
        return DFLTypeFactory.UNKNOWN;
    }

    private Optional<IDFLField> toField(KeyValuePair keyValuePair) {
        String keyName;
        Key key = keyValuePair.getKey();
        Expression value = keyValuePair.getValue();
        String string = keyName = key.getValue() instanceof StringLiteral ? ((StringLiteral)key.getValue()).getValue() : null;
        if (keyName != null) {
            DeclaredNamespace namespace = key.getNamespace();
            QName qname = DFLModelHelper.toQName((DeclaredNamespace)namespace, (String)keyName);
            Attributes keyAttrs = key.getAttributes();
            ArrayList<IDFLField> attributeFields = new ArrayList<IDFLField>();
            if (keyAttrs != null) {
                EList attributes = keyAttrs.getAttributes();
                for (AttributeElement attributeElement : attributes) {
                    Attribute attribute;
                    if (!(attributeElement instanceof Attribute) || (attribute = (Attribute)attributeElement).getName() == null) continue;
                    attributeFields.add(DFLTypeFactory.field(DFLModelHelper.toQName((DeclaredNamespace)attribute.getNamespace(), (String)attribute.getName()), this.doSwitch((EObject)attribute.getValue())));
                }
            }
            IDFLType fieldValueType = this.doSwitch((EObject)value);
            return Optional.of(DFLTypeFactory.field(qname, fieldValueType, attributeFields));
        }
        return Optional.empty();
    }

    public IDFLType caseKeyValuePair(KeyValuePair object) {
        return this.doSwitch((EObject)object.getValue());
    }

    public IDFLType caseArray(Array array) {
        DflFactoryUtils.ArrayWrapper wrapper = DflFactoryUtils.from(array);
        List<ArrayElement> elements = wrapper.getElements();
        if (elements.isEmpty()) {
            return DFLTypeFactory.ANY_ARRAY;
        }
        List<IDFLType> resolvedTypes = elements.stream().map(this::doSwitch).collect(Collectors.toList());
        if (this.allAreObjects(resolvedTypes)) {
            List<IDFLField> fieldsUnion = resolvedTypes.stream().flatMap(element -> {
                IDFLObjectType object = element.asObjectType();
                return object.getFields().stream();
            }).collect(Collectors.toList());
            return DFLTypeFactory.arrayOf(DFLTypeFactory.objectWith(fieldsUnion));
        }
        return DFLTypeFactory.arrayOf(this.doSwitch((EObject)elements.get(0)));
    }

    private boolean allAreObjects(List<IDFLType> resolvedTypes) {
        return resolvedTypes.stream().allMatch(IDFLType::isObject);
    }

    public IDFLType caseAnyRegexLiteral(AnyRegexLiteral object) {
        return DFLTypeFactory.REGEX;
    }

    public IDFLType caseQuotedStringLiteral(QuotedStringLiteral object) {
        return DFLTypeFactory.STRING;
    }

    public IDFLType caseStringLiteral(StringLiteral object) {
        return DFLTypeFactory.STRING;
    }

    public IDFLType caseBooleanLiteral(BooleanLiteral object) {
        return DFLTypeFactory.BOOLEAN;
    }

    public IDFLType caseIntegerLiteral(IntegerLiteral object) {
        return DFLTypeFactory.NUMBER;
    }

    public IDFLType caseSingleKeyValuePairObj(SingleKeyValuePairObj object) {
        Optional<Object> field = Optional.empty();
        KeyValuePair element = object.getObjectElement();
        if (element instanceof KeyValuePair) {
            field = this.toField(element);
        }
        return field.isPresent() ? DFLTypeFactory.objectWith(Arrays.asList((IDFLField)field.get())) : DFLTypeFactory.ANY_OBJECT;
    }

    public IDFLType caseDotSelector(DotSelector object) {
        if (object.getType().equals(".@")) {
            return this.resolveAttributeType(object);
        }
        if (object.getType().equals(".*")) {
            IDFLType result = this.doSwitch((EObject)object.getData());
            SelectorOrFunction selector = object.getSelector();
            return DFLTypeFactory.arrayOf(selector != null ? DFLModelTypeResolverImpl.selectValue(result, selector.getName()) : DFLTypeFactory.UNKNOWN);
        }
        IDFLType result = this.doSwitch((EObject)object.getData());
        SelectorOrFunction selector = object.getSelector();
        return selector != null ? DFLModelTypeResolverImpl.selectValue(result, selector.getName()) : DFLTypeFactory.UNKNOWN;
    }

    private IDFLType resolveAttributeType(DotSelector object) {
        DotSelectorProposalFieldsProvider provider = new DotSelectorProposalFieldsProvider();
        List<IDFLField> attributes = provider.getAttributes((EObject)object.getData(), this);
        for (IDFLField attribute : attributes) {
            String selectorName;
            String attrName = attribute.getName().getLocalPart();
            if (!attrName.equals(selectorName = object.getSelector().getName())) continue;
            return attribute.getType();
        }
        return DFLTypeFactory.UNKNOWN;
    }

    public static IDFLType selectValue(IDFLType result, String selector) {
        if (result.isObject()) {
            IDFLObjectType objectType = result.asObjectType();
            return DFLModelTypeResolverImpl.resolveSelectorType(selector, objectType);
        }
        if (result.isArray()) {
            IDFLType arrayType = result.asArrayType().getType();
            if (arrayType.isObject()) {
                IDFLObjectType objectType = arrayType.asObjectType();
                return DFLTypeFactory.arrayOf(DFLModelTypeResolverImpl.resolveSelectorType(selector, objectType));
            }
            return DFLTypeFactory.UNKNOWN;
        }
        return DFLTypeFactory.UNKNOWN;
    }

    private static IDFLType resolveSelectorType(String selector, IDFLObjectType objectType) {
        List<IDFLField> fields = objectType.getFields();
        for (IDFLField field : fields) {
            IDFLArrayType arrayType;
            if (!DFLModelTypeResolverImpl.matchesField(field, selector)) continue;
            if (field.getType() instanceof IDFLArrayType && (arrayType = (IDFLArrayType)field.getType()).isUnbounded()) {
                return arrayType.getType();
            }
            return field.getType();
        }
        return DFLTypeFactory.UNKNOWN;
    }

    public IDFLType caseSelector(Selector object) {
        return this.doSwitch(object.eContainer());
    }

    public IDFLType caseDynamicSelector(DynamicSelector object) {
        Expression expression = object.getExpression();
        IDFLType result = this.doSwitch((EObject)object.getData());
        if (expression instanceof QuotedStringLiteral) {
            return DFLModelTypeResolverImpl.selectValue(result, ((QuotedStringLiteral)expression).getValue());
        }
        if (expression instanceof IntegerLiteral) {
            int index = ((IntegerLiteral)expression).getValue().intValue();
            return this.selectIndex(result, index);
        }
        if (expression instanceof BinaryFunction) {
            return result;
        }
        return (IDFLType)super.caseDynamicSelector(object);
    }

    private IDFLType selectIndex(IDFLType result, int index) {
        if (result.isObject()) {
            List<IDFLField> fields = result.asObjectType().getFields();
            if (fields.size() > index) {
                IDFLField idflField = fields.get(index);
                return idflField.getType();
            }
        } else {
            if (result.isArray()) {
                return result.asArrayType().getType();
            }
            if (DFLTypeFactory.STRING.isAssignableFrom(result)) {
                return DFLTypeFactory.STRING;
            }
        }
        return DFLTypeFactory.UNKNOWN;
    }

    public IDFLType caseValueSelector(ValueSelector object) {
        IDFLType result = this.doSwitch((EObject)object.getData());
        StringSelector selector = object.getSelector();
        return selector != null ? DFLModelTypeResolverImpl.selectValue(result, selector.getName()) : DFLTypeFactory.UNKNOWN;
    }

    private static boolean matchesField(IDFLField field, String name) {
        String selectorValue = DFLModelHelper.removeQuotes((String)name);
        return field.getName().getLocalPart().equals(selectorValue);
    }

    public IDFLType caseVariableReference(VariableReference object) {
        String reference = object.getReference();
        Optional<IDFLType> variable = this.context.getVariable(reference);
        return variable.orElse(DFLTypeFactory.UNKNOWN);
    }

    public IDFLType caseFunctionCall(FunctionCall object) {
        String reference;
        switch (reference = object.getName()) {
            case "sizeOf": {
                return new SizeOfOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)));
            }
            case "trim": {
                return new TrimOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)));
            }
            case "upper": {
                return new UpperOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)));
            }
            case "lower": {
                return new LowerOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)));
            }
            case "++": {
                return new AppendOperationDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "filter": {
                return new FilterOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "reduce": {
                return new ReduceOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "orderBy": {
                return new OrderByOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "map": {
                return new MapOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "mapObject": {
                return new MapObjectOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "groupBy": {
                return new GroupByOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "to": {
                return new ToOperationDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "splitBy": {
                return new SplitByOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "startsWith": {
                return new StartsWithOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "endsWith": {
                return new EndsWithOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "contains": {
                return new ContainsOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
            case "pluck": {
                return new PluckObjectOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)this.getParameter(object, 0)), this.doSwitch((EObject)this.getParameter(object, 1)));
            }
        }
        Optional<IDFLType> variable = this.context.getVariable(reference);
        return variable.isPresent() ? variable.get() : DFLTypeFactory.UNKNOWN;
    }

    private Expression getParameter(FunctionCall object, int index) {
        FunctionCallArgs parameters = object.getParameters();
        if (parameters == null) {
            return null;
        }
        EList parameterList = parameters.getParameters();
        if (parameterList == null || index >= parameterList.size()) {
            return null;
        }
        return (Expression)parameterList.get(index);
    }

    private Optional<Pair<Container, MuleConfiguration>> getFlowAndConfigInProject(IMuleProject project, String flowName) {
        List configurations = project.getConfigurationsCache().getConfigurations();
        for (MuleConfiguration muleConfiguration : configurations) {
            Optional flow = muleConfiguration.getFlow(flowName);
            if (!flow.isPresent()) continue;
            return Optional.of(Pair.of((Object)((Container)flow.get()), (Object)muleConfiguration));
        }
        return Optional.empty();
    }

    private Optional<String> getLookupFlowName(FunctionCall object) {
        Expression expr;
        BasicEList.UnmodifiableEList parameters = new BasicEList.UnmodifiableEList(0, new Object[0]);
        if (!parameters.isEmpty() && (expr = (Expression)parameters.get(0)) instanceof QuotedStringLiteral) {
            String str = ((QuotedStringLiteral)expr).getValue();
            String unquotedStr = str.substring(1, str.length() - 1);
            return Optional.of(unquotedStr);
        }
        return Optional.empty();
    }

    public IDFLType caseDollarVariable(DollarVariable object) {
        String money = object.getTokens().stream().collect(Collectors.joining());
        Optional<IDFLType> dollar = this.context.getVariable(money);
        return dollar.orElse(DFLTypeFactory.UNKNOWN);
    }

    public IDFLType caseClojureOperatorOrOrExpression(ClojureOperatorOrOrExpression object) {
        return DFLTypeFactory.lambdaOf(this.context, object);
    }

    public IDFLType caseClojureOperator(ClojureOperator object) {
        return DFLTypeFactory.lambdaOf(this.context, object);
    }

    public IDFLType caseLambdaLiteral(LambdaLiteral object) {
        return DFLTypeFactory.lambdaOf(this.context, object);
    }

    public IDFLType caseBinaryFunction(BinaryFunction object) {
        ClojureOperatorOrOrExpression function;
        block45: {
            String variableName;
            function = object.getFunction();
            if (!(object.getFunctionName() instanceof VariableReference)) break block45;
            switch (variableName = ((VariableReference)object.getFunctionName()).getReference()) {
                case "++": {
                    return new AppendOperationDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "filter": {
                    return new FilterOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "reduce": {
                    return new ReduceOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "orderBy": {
                    return new OrderByOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "map": {
                    return new MapOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "mapObject": {
                    return new MapObjectOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "groupBy": {
                    return new GroupByOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "to": {
                    return new ToOperationDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "splitBy": {
                    return new SplitByOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "startsWith": {
                    return new StartsWithOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "endsWith": {
                    return new EndsWithOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "contains": {
                    return new ContainsOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
                case "pluck": {
                    return new PluckObjectOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getElement()), this.doSwitch((EObject)object.getFunction()));
                }
            }
        }
        if (function != null) {
            if (function.getOrExpression() != null) {
                return this.doSwitch((EObject)function.getOrExpression());
            }
            return this.doSwitch((EObject)function.getClojureOperator());
        }
        return DFLTypeFactory.UNKNOWN;
    }

    public IDFLType caseFunctionDirective(FunctionDirective object) {
        LambdaLiteral function = object.getFunction();
        EList parameters = function.getFParameters();
        List<String> paramNames = parameters.stream().map(FunctionParameter::getName).collect(Collectors.toList());
        return DFLTypeFactory.lambdaOf(this.context, (EObject)function.getExpression(), paramNames);
    }

    public IDFLType caseNullLiteral(NullLiteral object) {
        return DFLTypeFactory.NULL;
    }

    public IDFLType caseFilterSelector(FilterSelector object) {
        return new FilterOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getData()), this.doSwitch((EObject)object.getExpression()));
    }

    public IDFLType caseOr(Or object) {
        return new OrOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getLeft()), this.doSwitch((EObject)object.getRight()));
    }

    public IDFLType caseNotEqual(NotEqual object) {
        return DFLTypeFactory.BOOLEAN;
    }

    public IDFLType caseIs(Is object) {
        return DFLTypeFactory.BOOLEAN;
    }

    public IDFLType caseObjectSimpleType(ObjectSimpleType object) {
        Schema schema = object.getSchema();
        if (schema != null) {
            return DFLTypeFactory.extendFrom(DFLTypeFactory.ANY_OBJECT, "Object$", DFLTypeSystem.loadSchemaToMap(schema));
        }
        return DFLTypeFactory.ANY_OBJECT;
    }

    public IDFLType caseAs(As object) {
        EList types;
        TypeExpression type = object.getType();
        EList intersectionTypes = type.getTypes();
        if (intersectionTypes != null && !intersectionTypes.isEmpty() && (types = ((IntersectionTypeExpression)intersectionTypes.get(0)).getTypes()) != null && !types.isEmpty()) {
            BasicTypeExpression singleType = (BasicTypeExpression)types.get(0);
            if (singleType instanceof TypeReference) {
                TypeReference asType = (TypeReference)singleType;
                String name = asType.getFullQualifiedName();
                Optional<IDFLType> lookupType = this.typeSystem.lookupType(name);
                if (lookupType.isPresent()) {
                    IDFLType doSwitch;
                    IDFLType asDflType = lookupType.get();
                    Schema schema = asType.getSchema();
                    if (schema != null) {
                        asDflType = DFLTypeFactory.extendFrom(lookupType.get(), name + "$", DFLTypeSystem.loadSchemaToMap(schema));
                    }
                    if ((doSwitch = this.doSwitch((EObject)object.getElement())).isArray() && asDflType.isArray()) {
                        return asDflType.asArrayType().withType(doSwitch.asArrayType().getType());
                    }
                    return asDflType;
                }
            } else {
                return this.doSwitch((EObject)singleType);
            }
        }
        return DFLTypeFactory.UNKNOWN;
    }

    public IDFLType caseEqual(Equal object) {
        return DFLTypeFactory.BOOLEAN;
    }

    public IDFLType caseSimilar(Similar object) {
        return DFLTypeFactory.BOOLEAN;
    }

    public IDFLType caseTypeExpression(TypeExpression object) {
        return DFLTypeFactory.TYPE;
    }

    public IDFLType caseGreaterThan(GreaterThan object) {
        return DFLTypeFactory.BOOLEAN;
    }

    public IDFLType caseGreaterThanEqual(GreaterThanEqual object) {
        return DFLTypeFactory.BOOLEAN;
    }

    public IDFLType caseLessThan(LessThan object) {
        return DFLTypeFactory.BOOLEAN;
    }

    public IDFLType caseLessThanEqual(LessThanEqual object) {
        return DFLTypeFactory.BOOLEAN;
    }

    public IDFLType casePlus(Plus object) {
        return new AdditionOperationDescriptor().getReturnTypes(this.doSwitch((EObject)object.getLeft()), this.doSwitch((EObject)object.getRight()));
    }

    public IDFLType caseMinus(Minus object) {
        return new SubtractionOperationDescription().getReturnTypes(this.doSwitch((EObject)object.getLeft()), this.doSwitch((EObject)object.getRight()));
    }

    public IDFLType caseRightShift(RightShift object) {
        return new RightShiftOperationDescriptor().getReturnTypes(this.doSwitch((EObject)object.getLeft()), this.doSwitch((EObject)object.getRight()));
    }

    public IDFLType caseMultiply(Multiply object) {
        return new MultiplyOperationDescriptor().getReturnTypes(this.doSwitch((EObject)object.getLeft()), this.doSwitch((EObject)object.getRight()));
    }

    public IDFLType caseDivision(Division object) {
        return new DivisionOperationDescriptor().getReturnTypes(this.doSwitch((EObject)object.getLeft()), this.doSwitch((EObject)object.getRight()));
    }

    public IDFLType caseAnd(And object) {
        return new AndOperatorDescriptor().getReturnTypes(this.doSwitch((EObject)object.getLeft()), this.doSwitch((EObject)object.getRight()));
    }

    public IDFLType caseUnaryMinus(UnaryMinus object) {
        return DFLTypeFactory.NUMBER;
    }

    public IDFLType caseAnyDateLiteral(AnyDateLiteral object) {
        return DFLTypeFactory.DATE;
    }

    public IDFLType caseRealLiteral(RealLiteral object) {
        return DFLTypeFactory.NUMBER;
    }

    public IDFLType doSwitch(EObject eObject) {
        IDFLType doSwitch;
        if (eObject == null) {
            return DFLTypeFactory.UNKNOWN;
        }
        if (this.typeSystem == null) {
            this.typeSystem = DFLTypeSystem.create(DFLModelHelper.getRootDocument((EObject)eObject));
        }
        if ((doSwitch = (IDFLType)super.doSwitch(eObject)) == null) {
            return DFLTypeFactory.UNKNOWN;
        }
        return doSwitch;
    }

    @Override
    public IDFLType getReturnType(EObject eObject) {
        return this.doSwitch(eObject);
    }
}

