/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.adaptor;

import com.google.inject.Injector;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.ui.DFLExtendedActivator;
import org.mule.tooling.utils.SilentRunner;

public class DFLModelLoadingAdapter
implements IAdapterFactory {
    private static Logger log = Logger.getLogger(DFLModelLoadingAdapter.class);
    private static final Injector injector = DFLExtendedActivator.getInstance().getInjector("org.mule.tooling.dfl.DFL");

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == Document.class) {
            if (injector == null) {
                log.error((Object)"Could not obtain injector for Weave DSL");
                return null;
            }
            if (adaptableObject instanceof ISelection) {
                ISelection sel = (ISelection)adaptableObject;
                if (!(sel instanceof IStructuredSelection)) {
                    return null;
                }
                IStructuredSelection selection = (IStructuredSelection)sel;
                if (!(selection.getFirstElement() instanceof IFile)) {
                    return null;
                }
                adaptableObject = (IFile)selection.getFirstElement();
            }
            if (adaptableObject instanceof IFile) {
                Resource resource;
                final IFile file = (IFile)adaptableObject;
                if (!file.getFileExtension().toLowerCase().equals("dwl")) {
                    return null;
                }
                XtextResourceSet resourceSet = (XtextResourceSet)((XtextResourceSetProvider)injector.getInstance(XtextResourceSetProvider.class)).get(file.getProject());
                resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
                java.net.URI locationURI = file.getLocationURI();
                if (locationURI == null) {
                    resource = resourceSet.createResource(URI.createFileURI((String)file.getFullPath().toOSString()));
                    SilentRunner.run((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            Throwable throwable = null;
                            Object var2_3 = null;
                            try (InputStream fileContents = file.getContents();){
                                resource.load(fileContents, null);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            return null;
                        }
                    }, null);
                } else {
                    resource = resourceSet.getResource(URI.createURI((String)locationURI.toString()), true);
                }
                if (!resource.getContents().isEmpty()) {
                    return adapterType.cast(resource.getContents().get(0));
                }
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{Document.class};
    }
}

