/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui.actions.input.add;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.mule.tooling.dfl.dFL.Document;
import org.mule.tooling.dfl.dFL.Header;
import org.mule.tooling.dfl.dFL.VariableDirective;
import org.mule.tooling.dfl.ui.actions.input.add.ConstantDirectiveUI;
import org.mule.tooling.dfl.ui.scafflod.ScaffoldingHelper;
import org.mule.tooling.ui.widgets.dialog.IDialogEditorPresenter;
import org.mule.tooling.ui.widgets.dialog.IEditorMessageLogger;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class AddConstantDirectiveController
implements IDialogEditorPresenter<ConstantDirectiveUI> {
    private IEditorMessageLogger logger;
    private ConstantDirectiveUI editor;
    private SettableFuture<IXtextDocument> documentRef;

    public AddConstantDirectiveController(SettableFuture<IXtextDocument> documentRef) {
        this.documentRef = documentRef;
    }

    public void handle(ConstantDirectiveUI editor) {
        this.editor = editor;
        WidgetUtils widgetUtils = new WidgetUtils();
        widgetUtils.addEmptyTextConstrain(editor.getNameField(), "Name", this.logger);
        widgetUtils.addEmptyTextConstrain(editor.getValueField(), "Value", this.logger);
    }

    public void onSave() {
        ((IXtextDocument)Futures.getUnchecked(this.documentRef)).modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource state) throws Exception {
                EList contents = state.getContents();
                Document document = (Document)contents.get(0);
                Header header = ScaffoldingHelper.buildHeader(ScaffoldingHelper.buildBody(document));
                VariableDirective constDirective = ScaffoldingHelper.buildConstDirective(header, AddConstantDirectiveController.this.editor.getNameField().getText(), AddConstantDirectiveController.this.editor.getValueField().getText());
                header.getDirectives().add((Object)constDirective);
            }
        });
    }

    public void onCancel() {
    }

    public void setMessageLogger(IEditorMessageLogger logger) {
        this.logger = logger;
    }

    public void validate() {
    }
}

