/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.dfl.ui;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.xtext.util.Modules2;
import org.mule.tooling.dfl.ide.DFLIdeModule;
import org.mule.tooling.dfl.ui.contentassist.evaluator.DwelModuleInjector;
import org.mule.tooling.dfl.ui.internal.DflActivator;
import org.mule.tooling.platform.debug.DebugTraceProvider;
import org.mule.tooling.ui.widgets.image.PluginImageRegistry;
import org.osgi.framework.BundleContext;

public class DFLExtendedActivator
extends DflActivator {
    public static final String PLUGIN_ID = "org.mule.tooling.dfl.ui";
    public static final String JAR_INDEXER_ID = DebugTraceProvider.createDebugOptions((String)"/jar-indexer");
    public static final String JAR_INDEXER_TRACE_ID = DebugTraceProvider.createDebugOptions((String)"/jar-indexer-trace");
    private static DFLExtendedActivator INSTANCE;
    private DebugTraceProvider debugTraceProvider;
    private Job initInjectorJob;

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.debugTraceProvider = DebugTraceProvider.newRegisterdInstance((BundleContext)context, (String)PLUGIN_ID);
        INSTANCE = this;
        this.initInjectorJob = Job.createSystem((String)"Initialize DWEL Module Injector", (ICoreRunnable)new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                DwelModuleInjector.dflInjector();
            }
        });
        this.initInjectorJob.schedule();
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        INSTANCE = null;
        SafeRunner.run(() -> {
            this.initInjectorJob.cancel();
            this.initInjectorJob.join();
        });
        super.stop(context);
    }

    @Override
    protected Injector createInjector(String language) {
        try {
            Module runtimeModule = this.getRuntimeModule(language);
            Module ideModule = this.getIdeModule(language);
            Module sharedStateModule = this.getSharedStateModule();
            Module uiModule = this.getUiModule(language);
            Module mergedModule = Modules2.mixin((Module[])new Module[]{runtimeModule, ideModule, sharedStateModule, uiModule});
            return Guice.createInjector((Module[])new Module[]{mergedModule});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create injector for " + language, e);
        }
    }

    protected Module getIdeModule(String grammar) {
        if ("org.mule.tooling.dfl.DFL".equals(grammar)) {
            return new DFLIdeModule();
        }
        throw new IllegalArgumentException(grammar);
    }

    public static DFLExtendedActivator getInstance() {
        return INSTANCE;
    }

    public PluginImageRegistry getImages() {
        return new PluginImageRegistry(this.getBundle());
    }

    public static DebugTrace getDebugTrace() {
        return DFLExtendedActivator.INSTANCE.debugTraceProvider.debugTrace();
    }

    public IPreferenceStore getPreferenceStore() {
        return super.getPreferenceStore();
    }
}

