/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.util;

import com.mulesoft.mule.runtime.module.batch.BatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.BatchProperties;
import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.extension.error.BatchError;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.exception.BatchException;
import com.mulesoft.mule.runtime.module.batch.internal.BatchErrorTypes;
import com.mulesoft.mule.runtime.module.batch.internal.error.DefaultBatchError;
import com.mulesoft.mule.runtime.module.batch.internal.exception.ErrorWrapperException;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchUtils.class);
    private static final String ERROR_MESSAGE_DELIMITER = BatchUtils.repeat('*', 80) + System.lineSeparator();

    public static Record getRecord(CoreEvent event) {
        Object payload = CoreEvent.getVariableValueOrNull((String)"_mule_batch_INTERNAL_record", (CoreEvent)event);
        if (payload instanceof Record) {
            return (Record)payload;
        }
        payload = event.getMessage().getPayload().getValue();
        if (payload instanceof Record) {
            return (Record)payload;
        }
        throw BatchUtils.noRecordException();
    }

    public static Record getRecord(BindingContext bindingContext) {
        Optional<Map<String, TypedValue>> vars = BatchUtils.lookup("vars", bindingContext);
        Optional record = BatchUtils.getVariable("_mule_batch_INTERNAL_record", vars);
        if (!record.isPresent()) {
            record = BatchUtils.lookup("payload", bindingContext);
        }
        return (Record)record.orElseThrow(() -> BatchUtils.noRecordException());
    }

    private static <T> Optional<T> getVariable(String name, Optional<Map<String, TypedValue>> vars) {
        if (vars.isPresent() && vars.get().containsKey(name)) {
            return Optional.of(vars.get().get(name).getValue());
        }
        return Optional.empty();
    }

    private static RuntimeException noRecordException() {
        return new IllegalStateException("No record available in context. recordVars() function can only be used inside a batch step.");
    }

    private static <T> Optional<T> lookup(String key, BindingContext bindingContext) {
        return bindingContext.lookup(key).map(TypedValue::getValue);
    }

    public static BatchException toBatchException(Exception e, BatchJobInstanceAdapter jobInstance) {
        if (e instanceof BatchException) {
            return (BatchException)((Object)e);
        }
        return new BatchException(e, (BatchJobInstance)jobInstance);
    }

    public static Record toRecord(CoreEvent event, Object object) {
        Record record;
        if (object instanceof Message) {
            Message message = (Message)object;
            record = new Record((TypedValue<Object>)message.getPayload(), (TypedValue<Object>)message.getAttributes());
        } else {
            record = object instanceof TypedValue ? new Record((TypedValue<Object>)((TypedValue)object)) : new Record((TypedValue<Object>)TypedValue.of((Object)object));
        }
        record.replaceVariables(event.getVariables());
        BatchProperties.ALL_INTERNAL_VARS.forEach(record::removeVariable);
        return record;
    }

    public static String buildErrorLogMessage(BatchJobInstance jobInstance, BatchStep step, BatchError error) {
        boolean verbose = MuleException.isVerboseExceptions();
        StringBuilder sb = new StringBuilder();
        sb.append("Found error processing record on step '").append(step.getName()).append("' for job instance '").append(jobInstance.getId()).append("' of job '").append(jobInstance.getOwnerJobName()).append("'.").append(System.lineSeparator()).append("This is the first record to show this error on this step for this job instance. ").append("Subsequent records with the same failures will not be logged for performance and log readability reasons:").append(System.lineSeparator()).append(System.lineSeparator());
        BatchUtils.appendErrorBlock(sb, error, verbose);
        if (verbose) {
            BatchUtils.appendVerboseInnerError(sb, error.getFailureDuringHandling());
            BatchUtils.appendVerboseChildErrors(sb, error.getChildErrors());
        }
        return sb.toString();
    }

    private static void appendErrorBlock(StringBuilder sb, BatchError error, boolean verboseExceptions) {
        sb.append(ERROR_MESSAGE_DELIMITER).append("Message               : ").append(error.getDetailedDescription()).append(System.lineSeparator()).append("Element               : ").append(error.getFailingComponent()).append(System.lineSeparator()).append("Element DSL           : ").append(error.getDslSource()).append(System.lineSeparator()).append("Error type            : ").append(error.getErrorType());
        if (!verboseExceptions) {
            sb.append(BatchUtils.getFailureDuringHandlingMessage(error.getFailureDuringHandling())).append(BatchUtils.getChildErrorsMessage(error.getChildErrors()));
        }
        sb.append(System.lineSeparator()).append(ERROR_MESSAGE_DELIMITER).append("Stack Trace:").append(System.lineSeparator()).append(error.getStackTrace()).append(System.lineSeparator());
    }

    private static void appendVerboseInnerError(StringBuilder sb, BatchError innerError) {
        if (innerError == null) {
            return;
        }
        sb.append(System.lineSeparator()).append("Inner error:").append(System.lineSeparator());
        BatchUtils.appendErrorBlock(sb, innerError, true);
        BatchUtils.appendVerboseInnerError(sb, innerError.getFailureDuringHandling());
        BatchUtils.appendVerboseChildErrors(sb, innerError.getChildErrors());
    }

    private static void appendVerboseChildErrors(StringBuilder sb, List<BatchError> childErrors) {
        if (childErrors == null || childErrors.isEmpty()) {
            return;
        }
        for (int i = 0; i < childErrors.size(); ++i) {
            BatchError childError = childErrors.get(i);
            sb.append(System.lineSeparator()).append("Child error ").append(i + 1).append(" of ").append(childErrors.size()).append(":").append(System.lineSeparator());
            BatchUtils.appendErrorBlock(sb, childError, true);
            BatchUtils.appendVerboseInnerError(sb, childError.getFailureDuringHandling());
            BatchUtils.appendVerboseChildErrors(sb, childError.getChildErrors());
        }
    }

    private static String getFailureDuringHandlingMessage(BatchError error) {
        if (error != null) {
            return System.lineSeparator() + "Inner error           : " + String.valueOf(error.getErrorType()) + " - " + error.getDetailedDescription();
        }
        return "";
    }

    private static String getChildErrorsMessage(List<BatchError> childErrors) {
        if (childErrors == null || childErrors.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator()).append("Child errors          : ").append(childErrors.size());
        BatchUtils.appendChildErrors(sb, childErrors, 1);
        return sb.toString();
    }

    private static void appendChildErrors(StringBuilder sb, List<BatchError> childErrors, int depth) {
        if (childErrors == null || childErrors.isEmpty()) {
            return;
        }
        String indent = "  ".repeat(depth);
        Map groupedCounts = childErrors.stream().collect(Collectors.groupingBy(e -> String.valueOf(e.getErrorType()) + " - " + e.getDetailedDescription(), LinkedHashMap::new, Collectors.counting()));
        LinkedHashMap<CallSite, BatchError> firstErrorOfGroup = new LinkedHashMap<CallSite, BatchError>();
        for (BatchError batchError : childErrors) {
            String key = String.valueOf(batchError.getErrorType()) + " - " + batchError.getDetailedDescription();
            firstErrorOfGroup.putIfAbsent((CallSite)((Object)key), batchError);
        }
        for (Map.Entry entry : groupedCounts.entrySet()) {
            BatchError representative;
            sb.append(System.lineSeparator()).append(indent).append("- ").append((String)entry.getKey());
            if ((Long)entry.getValue() > 1L) {
                sb.append(" - (x").append(entry.getValue()).append(")");
            }
            if ((representative = (BatchError)firstErrorOfGroup.get(entry.getKey())) == null || representative.getChildErrors() == null || representative.getChildErrors().isEmpty()) continue;
            BatchUtils.appendChildErrors(sb, representative.getChildErrors(), depth + 1);
        }
    }

    public static String getFullStackTraceWithoutMessages(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        for (String frame : ExceptionUtils.getStackFrames((Throwable)throwable)) {
            builder.append(frame.replaceAll(":\\s+([\\w\\s]*.*)", "").trim()).append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static String getFullStackTraceWithoutMessages(String stackTrace) {
        StringBuilder builder = new StringBuilder();
        for (String frame : stackTrace.split(System.lineSeparator())) {
            builder.append(frame.replaceAll(":\\s+([\\w\\s]*.*)", "").trim()).append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static void commit(BatchTransactionContext ctx) {
        try {
            ctx.commit();
        }
        catch (ResourceManagerException e) {
            BatchUtils.logResourceException(ctx, "commit", (Exception)((Object)e));
            BatchUtils.rollback(ctx);
        }
    }

    public static void singleAckAndCommitIfNecessary(BatchTransactionContext ctx) {
        ctx.ackSingleRecordProcessed();
        if (ctx.isBlockCompleted()) {
            BatchUtils.commit(ctx);
        }
    }

    public static void rollback(BatchTransactionContext ctx) {
        try {
            ctx.rollback();
        }
        catch (ResourceManagerException e) {
            BatchUtils.logResourceException(ctx, "rollback", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void completeWorkOnBlock(List<Record> block, boolean shouldRollback, BatchProcessingListener listener, BatchTransactionContext ctx) {
        if (block != null) {
            block.forEach(record -> {
                if (record.getCompletionCallback() != null) {
                    record.getCompletionCallback().decrementConsumers();
                }
            });
        }
        if (shouldRollback) {
            try {
                BatchUtils.rollback(ctx);
            }
            finally {
                if (listener != null && block != null && !block.isEmpty()) {
                    listener.onSteppingQueueDispatch(ctx.getJobInstance(), block);
                }
            }
        }
    }

    public static BatchError extractError(Exception exception) {
        if (exception instanceof ErrorWrapperException) {
            ErrorWrapperException errorWrapperException = (ErrorWrapperException)((Object)exception);
            return errorWrapperException.getError();
        }
        Throwable t = BatchUtils.findMessagingException(exception);
        if (t instanceof MessagingException) {
            MessagingException messagingException = (MessagingException)t;
            return DefaultBatchError.fromMessagingException(messagingException);
        }
        return DefaultBatchError.fromError(ErrorBuilder.builder((Throwable)exception).errorType(BatchErrorTypes.BATCH_ERROR_TYPE).build());
    }

    private static Throwable findMessagingException(Throwable exception) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        while (exception != null && seen.add(exception)) {
            if (exception instanceof MessagingException) {
                return exception;
            }
            exception = exception.getCause();
        }
        return exception;
    }

    private static void logResourceException(BatchTransactionContext ctx, String operation, Exception e) {
        LOGGER.error(String.format("Could not %s transaction for processing block '%s' processing instance '%s' of job '%s'", operation, ctx.getId(), ctx.getJobInstance().getId(), ctx.getJobInstance().getOwnerJobName()), (Throwable)e);
    }

    private static String repeat(char c, int len) {
        String str = String.valueOf(c);
        if (str == null) {
            return null;
        }
        if (len <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }
}

