/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.reporting;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.extension.error.BatchError;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.error.ErrorHistory;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import org.slf4j.Logger;

public class StepErrorReporter {
    private final BatchStep step;
    private final Logger logger;
    private final LoadingCache<BatchJobInstance, ErrorHistory> histories = Caffeine.newBuilder().build(key -> new ErrorHistory());

    public StepErrorReporter(BatchStep step, Logger logger) {
        this.step = step;
        this.logger = logger;
    }

    public void report(BatchJobInstanceAdapter jobInstance, BatchError error) {
        ErrorHistory history = (ErrorHistory)this.histories.get((Object)jobInstance);
        if (history != null && history.add(error) && this.logger.isInfoEnabled()) {
            this.logger.info(BatchUtils.buildErrorLogMessage(jobInstance, this.step, error));
        }
    }

    public void reset(BatchJobInstanceAdapter jobInstance) {
        this.histories.invalidate((Object)jobInstance);
    }

    public ErrorHistory getErrorHistory(BatchJobInstanceAdapter jobInstance) {
        return (ErrorHistory)this.histories.asMap().get(jobInstance);
    }
}

