/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.privileged;

import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepErrorSummary;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepExceptionSummary;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepResult;
import com.mulesoft.mule.runtime.module.batch.internal.BatchErrorTypes;
import com.mulesoft.mule.runtime.module.batch.internal.DefaultBatchStepErrorSummary;
import com.mulesoft.mule.runtime.module.batch.internal.DefaultBatchStepExceptionSummary;
import com.mulesoft.mule.runtime.module.batch.privileged.ImmutableBatchStepErrorSummary;
import com.mulesoft.mule.runtime.module.batch.privileged.ImmutableBatchStepExceptionSummary;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.util.Map;

public final class ImmutableBatchStepResult
implements BatchStepResult {
    private static final long serialVersionUID = 2758228920790920130L;
    private final long receivedRecords;
    private final long successfulRecords;
    private final long failedRecords;
    private BatchStepErrorSummary errorSummary;

    ImmutableBatchStepResult(BatchStepResult result) {
        this.receivedRecords = result.getReceivedRecords();
        this.successfulRecords = result.getSuccessfulRecords();
        this.failedRecords = result.getFailedRecords();
        this.errorSummary = this.calculateErrorSummary(result);
    }

    public Object readResolve() {
        this.errorSummary = this.errorSummary == null ? new ImmutableBatchStepErrorSummary(new DefaultBatchStepErrorSummary()) : this.errorSummary;
        return this;
    }

    public ImmutableBatchStepResult(long receivedRecords, long successfulRecords, long failedRecords, BatchStepErrorSummary errorSummary) {
        this.receivedRecords = receivedRecords;
        this.successfulRecords = successfulRecords;
        this.failedRecords = failedRecords;
        this.errorSummary = errorSummary;
    }

    private BatchStepErrorSummary calculateErrorSummary(BatchStepResult result) {
        if (!result.getExceptionSummary().getExceptionsCount().isEmpty() && result.getErrorSummary() == null) {
            return this.toErrorSummary(result.getExceptionSummary());
        }
        return result.getErrorSummary() instanceof ImmutableBatchStepErrorSummary ? result.getErrorSummary() : new ImmutableBatchStepErrorSummary(result.getErrorSummary());
    }

    private BatchStepErrorSummary toErrorSummary(BatchStepExceptionSummary exceptionSummary) {
        DefaultBatchStepErrorSummary errorSummary = new DefaultBatchStepErrorSummary();
        exceptionSummary.getExceptionsCount().forEach((exception, count) -> {
            for (long i = 0L; i < count; ++i) {
                errorSummary.account(BatchErrorTypes.BATCH_ERROR_TYPE);
            }
        });
        return new ImmutableBatchStepErrorSummary(errorSummary);
    }

    public long getReceivedRecords() {
        return this.receivedRecords;
    }

    public long getSuccessfulRecords() {
        return this.successfulRecords;
    }

    public long getFailedRecords() {
        return this.failedRecords;
    }

    public BatchStepExceptionSummary getExceptionSummary() {
        return new ImmutableBatchStepExceptionSummary(new DefaultBatchStepExceptionSummary());
    }

    public BatchStepErrorSummary getErrorSummary() {
        return this.errorSummary;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.setFinalField("receivedRecords", fields.get("receivedRecords", 0L));
        this.setFinalField("successfulRecords", fields.get("successfulRecords", 0L));
        this.setFinalField("failedRecords", fields.get("failedRecords", 0L));
        BatchStepErrorSummary summary = (BatchStepErrorSummary)fields.get("errorSummary", null);
        if (summary == null) {
            summary = this.convertExceptionSummaryToErrorSummary(fields, "exceptionSummary");
        }
        if (summary == null) {
            summary = new ImmutableBatchStepErrorSummary(new DefaultBatchStepErrorSummary());
        }
        this.setFinalField("errorSummary", summary);
    }

    private BatchStepErrorSummary convertExceptionSummaryToErrorSummary(ObjectInputStream.GetField fields, String fieldName) {
        try {
            Object value = fields.get(fieldName, null);
            if (value != null) {
                ImmutableBatchStepExceptionSummary exceptionSummary = (ImmutableBatchStepExceptionSummary)value;
                DefaultBatchStepErrorSummary errorSummary = new DefaultBatchStepErrorSummary();
                if (exceptionSummary.getExceptionsCount() != null && !exceptionSummary.getExceptionsCount().isEmpty()) {
                    for (Map.Entry<Class<? extends Exception>, Long> entry : exceptionSummary.getExceptionsCount().entrySet()) {
                        Long count = entry.getValue();
                        for (long i = 0L; i < count; ++i) {
                            errorSummary.account(BatchErrorTypes.BATCH_ERROR_TYPE);
                        }
                    }
                }
                return new ImmutableBatchStepErrorSummary(errorSummary);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void setFinalField(String fieldName, Object value) {
        try {
            Field field = ImmutableBatchStepResult.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Failed to set field: " + fieldName, e);
        }
    }
}

