/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.privileged;

import com.mulesoft.mule.runtime.module.batch.api.extension.error.BatchError;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobResult;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepResult;
import com.mulesoft.mule.runtime.module.batch.privileged.BatchStepResultsProvider;
import com.mulesoft.mule.runtime.module.batch.privileged.ImmutableBatchStepResult;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ImmutableBatchJobResult
implements BatchJobResult,
BatchStepResultsProvider {
    private static final long serialVersionUID = 4323747859995526737L;
    private final Map<String, BatchStepResult> stepResults;
    private final long elapsedTimeInMillis;
    private final long successfulRecords;
    private final long failedRecords;
    private final long totalRecords;
    private final long loadedRecords;
    private final long processedRecords;
    private final String batchJobInstanceId;
    private final boolean failedOnInputPhase;
    private final boolean failedOnLoadingPhase;
    private final boolean failedOnCompletePhase;
    private final BatchError inputPhaseError;
    private final BatchError loadingPhaseError;
    private final BatchError onCompletePhaseError;

    public ImmutableBatchJobResult(BatchJobResult jobResult) {
        this.elapsedTimeInMillis = jobResult.getElapsedTimeInMillis();
        this.successfulRecords = jobResult.getSuccessfulRecords();
        this.failedRecords = jobResult.getFailedRecords();
        this.totalRecords = jobResult.getTotalRecords();
        this.loadedRecords = jobResult.getLoadedRecords();
        this.processedRecords = jobResult.getProcessedRecords();
        this.batchJobInstanceId = jobResult.getBatchJobInstanceId();
        this.failedOnInputPhase = jobResult.isFailedOnInputPhase();
        this.failedOnLoadingPhase = jobResult.isFailedOnLoadingPhase();
        this.failedOnCompletePhase = jobResult.isFailedOnCompletePhase();
        this.inputPhaseError = this.toError(jobResult.getInputPhaseError(), jobResult.getInputPhaseException());
        this.loadingPhaseError = this.toError(jobResult.getLoadingPhaseError(), jobResult.getLoadingPhaseException());
        this.onCompletePhaseError = this.toError(jobResult.getOnCompletePhaseError(), jobResult.getOnCompletePhaseException());
        HashMap<String, ImmutableBatchStepResult> stepResults = new HashMap<String, ImmutableBatchStepResult>();
        if (jobResult instanceof BatchStepResultsProvider) {
            for (Map.Entry<String, BatchStepResult> entry : ((BatchStepResultsProvider)jobResult).getBatchStepResults().entrySet()) {
                stepResults.put(entry.getKey(), new ImmutableBatchStepResult(entry.getValue()));
            }
        }
        this.stepResults = Collections.unmodifiableMap(stepResults);
    }

    public ImmutableBatchJobResult(String batchJobInstanceId, long elapsedTimeInMillis, long successfulRecords, long failedRecords, long totalRecords, long loadedRecords, long processedRecords, boolean failedOnInputPhase, boolean failedOnLoadingPhase, boolean failedOnCompletePhase, BatchError inputPhaseError, BatchError loadingPhaseError, BatchError onCompletePhaseError, Map<String, BatchStepResult> stepResults) {
        this.batchJobInstanceId = batchJobInstanceId;
        this.elapsedTimeInMillis = elapsedTimeInMillis;
        this.successfulRecords = successfulRecords;
        this.failedRecords = failedRecords;
        this.totalRecords = totalRecords;
        this.loadedRecords = loadedRecords;
        this.processedRecords = processedRecords;
        this.failedOnInputPhase = failedOnInputPhase;
        this.failedOnLoadingPhase = failedOnLoadingPhase;
        this.failedOnCompletePhase = failedOnCompletePhase;
        this.inputPhaseError = inputPhaseError;
        this.loadingPhaseError = loadingPhaseError;
        this.onCompletePhaseError = onCompletePhaseError;
        this.stepResults = stepResults;
    }

    private BatchError toError(BatchError currentError, Exception currentException) {
        if (currentError == null && currentException != null) {
            return BatchUtils.extractError(currentException);
        }
        return currentError;
    }

    public BatchStepResult getResultForStep(String stepId) {
        return this.stepResults.get(stepId);
    }

    public long getElapsedTimeInMillis() {
        return this.elapsedTimeInMillis;
    }

    public long getSuccessfulRecords() {
        return this.successfulRecords;
    }

    public long getFailedRecords() {
        return this.failedRecords;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public long getLoadedRecords() {
        return this.loadedRecords;
    }

    public long getProcessedRecords() {
        return this.processedRecords;
    }

    public String getBatchJobInstanceId() {
        return this.batchJobInstanceId;
    }

    public boolean isFailedOnInputPhase() {
        return this.failedOnInputPhase;
    }

    public Exception getInputPhaseException() {
        return null;
    }

    public BatchError getInputPhaseError() {
        return this.inputPhaseError;
    }

    public boolean isFailedOnLoadingPhase() {
        return this.failedOnLoadingPhase;
    }

    public Exception getLoadingPhaseException() {
        return null;
    }

    public BatchError getLoadingPhaseError() {
        return this.loadingPhaseError;
    }

    public boolean isFailedOnCompletePhase() {
        return this.failedOnCompletePhase;
    }

    public Exception getOnCompletePhaseException() {
        return null;
    }

    public BatchError getOnCompletePhaseError() {
        return this.onCompletePhaseError;
    }

    @Override
    public Map<String, BatchStepResult> getBatchStepResults() {
        return this.stepResults;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.setFinalField("batchJobInstanceId", fields.get("batchJobInstanceId", null));
        this.setFinalField("elapsedTimeInMillis", fields.get("elapsedTimeInMillis", 0L));
        this.setFinalField("successfulRecords", fields.get("successfulRecords", 0L));
        this.setFinalField("failedRecords", fields.get("failedRecords", 0L));
        this.setFinalField("totalRecords", fields.get("totalRecords", 0L));
        this.setFinalField("loadedRecords", fields.get("loadedRecords", 0L));
        this.setFinalField("processedRecords", fields.get("processedRecords", 0L));
        this.setFinalField("failedOnInputPhase", fields.get("failedOnInputPhase", false));
        this.setFinalField("failedOnLoadingPhase", fields.get("failedOnLoadingPhase", false));
        this.setFinalField("failedOnCompletePhase", fields.get("failedOnCompletePhase", false));
        this.setFinalField("stepResults", fields.get("stepResults", null));
        BatchError inputError = (BatchError)fields.get("inputPhaseError", null);
        BatchError loadingError = (BatchError)fields.get("loadingPhaseError", null);
        BatchError onCompleteError = (BatchError)fields.get("onCompletePhaseError", null);
        if (inputError == null) {
            inputError = this.convertExceptionToError(fields, "inputPhaseException");
        }
        if (loadingError == null) {
            loadingError = this.convertExceptionToError(fields, "loadingPhaseException");
        }
        if (onCompleteError == null) {
            onCompleteError = this.convertExceptionToError(fields, "onCompletePhaseException");
        }
        this.setFinalField("inputPhaseError", inputError);
        this.setFinalField("loadingPhaseError", loadingError);
        this.setFinalField("onCompletePhaseError", onCompleteError);
    }

    private BatchError convertExceptionToError(ObjectInputStream.GetField fields, String fieldName) {
        try {
            Exception exception = (Exception)fields.get(fieldName, null);
            if (exception != null) {
                return BatchUtils.extractError(exception);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void setFinalField(String fieldName, Object value) {
        try {
            Field field = ImmutableBatchJobResult.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Failed to set field: " + fieldName, e);
        }
    }
}

