/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.streaming;

import java.io.IOException;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.streaming.iterator.Producer;
import org.mule.runtime.core.api.util.queue.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationAwareQueueProducer<T>
implements Producer<T> {
    private static final Logger logger = LoggerFactory.getLogger(SerializationAwareQueueProducer.class);
    private static final long DEFAULT_TIMEOUT_VALUE = 1000L;
    private Queue queue;
    private ObjectSerializer serializer;
    private int size;
    private long timeout;

    public SerializationAwareQueueProducer(Queue queue, ObjectSerializer serializer) {
        this(queue, serializer, 1000L);
    }

    public SerializationAwareQueueProducer(Queue queue, ObjectSerializer serializer, long timeout) {
        if (queue == null) {
            throw new IllegalArgumentException("Cannot make a producer out of a null queue");
        }
        this.queue = queue;
        this.serializer = serializer;
        this.size = queue.size();
        this.timeout = timeout;
    }

    public T produce() {
        if (this.queue == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            bytes = (byte[])this.queue.poll(this.timeout);
        }
        catch (InterruptedException e) {
            logger.warn("Thread interrupted while polling in producer. Will return an empty list", (Throwable)e);
        }
        return (T)(bytes != null ? this.serializer.getInternalProtocol().deserialize(bytes) : null);
    }

    public void close() throws IOException {
        this.queue = null;
    }

    public int getSize() {
        return this.size;
    }
}

