/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.mulesoft.mule.runtime.module.batch.api.extension.error.BatchError;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.serialization.ObjectSerializer;

public class RecordSerializer
extends Serializer<Record> {
    private final ObjectSerializer defaultSerializer;

    public RecordSerializer(ObjectSerializer defaultSerializer) {
        this.defaultSerializer = defaultSerializer;
    }

    public void write(Kryo kryo, Output output, Record record) {
        kryo.writeObjectOrNull(output, record.getAttributes(), TypedValue.class);
        kryo.writeObjectOrNull(output, (Object)record.getCurrentStepId(), String.class);
        kryo.writeObjectOrNull(output, this.getField(record, "payload"), TypedValue.class);
        kryo.writeClassAndObject(output, this.getField(record, "processedSteps"));
        kryo.writeClassAndObject(output, this.getField(record, "stepErrors"));
        if (!record.getStepErrors().isEmpty()) {
            this.writeStepExceptionsWithJavaSerialization(output, (Map)this.getField(record, "stepExceptions"));
        }
        kryo.writeClassAndObject(output, this.getField(record, "variables"));
    }

    public Record read(Kryo kryo, Input input, Class<Record> type) {
        Record record = new Record();
        kryo.reference((Object)record);
        TypedValue attributes = (TypedValue)kryo.readObjectOrNull(input, TypedValue.class);
        String currentStepId = (String)kryo.readObjectOrNull(input, String.class);
        TypedValue payload = (TypedValue)kryo.readObjectOrNull(input, TypedValue.class);
        Set processedSteps = (Set)kryo.readClassAndObject(input);
        Object value = kryo.readClassAndObject(input);
        Map<String, BatchError> stepErrors = this.readErrorsOrExceptions(value);
        Map<String, Exception> stepExceptions = !stepErrors.isEmpty() && !this.isExceptions(value) ? this.readStepExceptionsWithJavaSerialization(input) : (Map<String, Exception>)value;
        Map variables = (Map)kryo.readClassAndObject(input);
        this.setField(record, "attributes", attributes);
        this.setField(record, "currentStepId", currentStepId);
        this.setField(record, "payload", payload);
        this.setField(record, "processedSteps", processedSteps);
        this.setField(record, "stepErrors", stepErrors);
        this.setField(record, "stepExceptions", stepExceptions);
        this.setField(record, "variables", variables);
        return record;
    }

    private Object getField(Record record, String fieldName) {
        try {
            Field field = Record.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(record);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Failed to get field: " + fieldName, e);
        }
    }

    private void setField(Record record, String fieldName, Object value) {
        try {
            Field field = Record.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(record, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Failed to set field: " + fieldName, e);
        }
    }

    private void writeStepExceptionsWithJavaSerialization(Output output, Map<String, Exception> stepExceptions) {
        byte[] bytes = this.defaultSerializer.getInternalProtocol().serialize(stepExceptions);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }

    private Map<String, Exception> readStepExceptionsWithJavaSerialization(Input input) {
        int length = input.readInt();
        byte[] bytes = input.readBytes(length);
        return (Map)this.defaultSerializer.getInternalProtocol().deserialize(bytes);
    }

    private Map<String, BatchError> readErrorsOrExceptions(Object value) {
        if (value == null) {
            return new HashMap<String, BatchError>();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                return new HashMap<String, BatchError>();
            }
            Object firstValue = map.values().iterator().next();
            if (firstValue instanceof BatchError) {
                return (Map)value;
            }
            if (firstValue instanceof Exception) {
                Map exceptions = (Map)value;
                HashMap<String, BatchError> errors = new HashMap<String, BatchError>();
                for (Map.Entry entry : exceptions.entrySet()) {
                    BatchError error = BatchUtils.extractError((Exception)entry.getValue());
                    if (error == null) continue;
                    errors.put((String)entry.getKey(), error);
                }
                return errors;
            }
        }
        throw new IllegalStateException("Unexpected type for stepErrors/stepExceptions field: " + value.getClass().getName());
    }

    private boolean isExceptions(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            Object firstValue = map.values().iterator().next();
            return firstValue instanceof Exception;
        }
        throw new IllegalStateException("Unexpected type for stepErrors/stepExceptions field: " + value.getClass().getName());
    }
}

