/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.error;

import com.mulesoft.mule.runtime.module.batch.api.extension.error.BatchError;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.exception.MuleExceptionInfo;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.privileged.exception.MessagingException;

public class DefaultBatchError
implements BatchError {
    private static final long serialVersionUID = 4785123456789012345L;
    private final String description;
    private final String detailedDescription;
    private final String failingComponent;
    private final ErrorType errorType;
    private final Message muleMessage;
    private final List<BatchError> errors;
    private final String dslSource;
    private final String stackTrace;
    private BatchError failureDuringHandling;

    private DefaultBatchError(String description, String detailedDescription, String failingComponent, ErrorType errorType, Message errorMessage, List<DefaultBatchError> errors, String dslSource, String stackTrace) {
        this.description = description;
        this.detailedDescription = detailedDescription;
        this.failingComponent = failingComponent;
        this.errorType = errorType;
        this.muleMessage = errorMessage;
        this.errors = Collections.unmodifiableList(errors);
        this.dslSource = dslSource;
        this.stackTrace = stackTrace;
    }

    public static DefaultBatchError fromMessagingException(MessagingException messagingException) {
        MuleExceptionInfo exceptionInfo = messagingException.getExceptionInfo();
        Error error = ErrorBuilder.builder((Throwable)messagingException).errorType(exceptionInfo.getErrorType()).build();
        List<DefaultBatchError> childErrors = DefaultBatchError.getChildErrors(error);
        return new DefaultBatchError(error.getDescription(), error.getDetailedDescription(), exceptionInfo.getLocation(), exceptionInfo.getErrorType(), error.getErrorMessage(), childErrors, exceptionInfo.getDslSource(), DefaultBatchError.getStackTrace(messagingException));
    }

    public static DefaultBatchError fromError(Error error) {
        List<DefaultBatchError> childErrors = DefaultBatchError.getChildErrors(error);
        return new DefaultBatchError(error.getDescription(), error.getDetailedDescription(), error.getFailingComponent(), error.getErrorType(), error.getErrorMessage(), childErrors, error.getDslSource(), DefaultBatchError.getStackTrace(error.getCause()));
    }

    private static String getStackTrace(Throwable cause) {
        try {
            return ExceptionUtils.getStackTrace((Throwable)cause);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static List<DefaultBatchError> getChildErrors(Error error) {
        return error.getChildErrors().stream().map(DefaultBatchError::fromError).toList();
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetailedDescription() {
        return this.detailedDescription;
    }

    public String getFailingComponent() {
        return this.failingComponent;
    }

    public String getDslSource() {
        return this.dslSource;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Message getErrorMessage() {
        return this.muleMessage;
    }

    public List<BatchError> getChildErrors() {
        return this.errors;
    }

    public void setFailureDuringHandling(BatchError failureDuringHandling) {
        this.failureDuringHandling = failureDuringHandling;
    }

    public BatchError getFailureDuringHandling() {
        return this.failureDuringHandling;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }
}

