/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.transaction;

import com.mulesoft.mule.runtime.module.batch.engine.BatchJobAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.UUID;

public class DefaultBatchTransactionContext
implements BatchTransactionContext {
    private final Serializable id;
    private final BatchJobAdapter job;
    private final QueueSession queueSession;
    private final AtomicInteger ackRecordCount = new AtomicInteger(0);
    private final AtomicBoolean transactionActive = new AtomicBoolean(false);
    private final CompletableFuture<Void> resolutionCallback = new CompletableFuture();
    private int blockSize;
    private BatchJobInstanceAdapter jobInstance;

    public DefaultBatchTransactionContext(BatchJobAdapter job, BatchJobInstanceAdapter jobInstance, QueueSession queueSession) {
        this.id = UUID.getUUID();
        this.job = job;
        this.jobInstance = jobInstance;
        this.queueSession = queueSession;
        this.blockSize = job.getBlockSize();
    }

    @Override
    public void ackProcessedRecords(int howMany) {
        this.ackRecordCount.addAndGet(howMany);
    }

    @Override
    public void ackSingleRecordProcessed() {
        this.ackProcessedRecords(1);
    }

    @Override
    public boolean isBlockCompleted() {
        return this.ackRecordCount.get() >= this.blockSize;
    }

    @Override
    public void updateJobInstance(BatchJobInstanceAdapter jobInstance) {
        Preconditions.checkArgument((jobInstance != null && this.job.getName().equals(jobInstance.getOwnerJobName()) && this.jobInstance.getId().equals(jobInstance.getId()) ? 1 : 0) != 0, (String)"Provided jobInstance is null or representing a different execution");
        this.jobInstance = jobInstance;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public void commit() throws ResourceManagerException {
        if (this.shouldToggleTxState()) {
            this.queueSession.commit();
            this.resolutionCallback.complete(null);
        }
    }

    @Override
    public void beginTransaction() throws ResourceManagerException {
        this.queueSession.begin();
        this.transactionActive.set(true);
    }

    @Override
    public void rollback() throws ResourceManagerException {
        if (this.shouldToggleTxState()) {
            this.queueSession.rollback();
            this.resolutionCallback.complete(null);
        }
    }

    private boolean shouldToggleTxState() {
        return this.transactionActive.compareAndSet(true, false);
    }

    @Override
    public Serializable getId() {
        return this.id;
    }

    @Override
    public BatchJobAdapter getJob() {
        return this.job;
    }

    @Override
    public BatchJobInstanceAdapter getJobInstance() {
        return this.jobInstance;
    }

    @Override
    public CompletableFuture<Void> getResolutionCallback() {
        return this.resolutionCallback;
    }

    @Override
    public Queue getQueue(String name) {
        return this.queueSession.getQueue(name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BatchTransactionContext) {
            return this.id.equals(((BatchTransactionContext)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

