/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.mulesoft.mule.runtime.module.batch.api.extension.error.BatchError;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.buffer.BatchContextTransactionManager;
import com.mulesoft.mule.runtime.module.batch.engine.queue.BatchQueueDelegate;
import com.mulesoft.mule.runtime.module.batch.engine.queue.BatchQueueManager;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.AbstractRecordBuffer;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionalQueueBuffer
extends AbstractRecordBuffer
implements BatchContextTransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalQueueBuffer.class);
    private final BatchEngine batchEngine;
    protected final BatchQueueManager batchQueueManager;
    private final boolean exceptionsDisabled;
    private final Map<BatchJobInstanceAdapter, Map<BatchTransactionContext, List<Record>>> buffer = new HashMap<BatchJobInstanceAdapter, Map<BatchTransactionContext, List<Record>>>();

    protected TransactionalQueueBuffer(String name, BatchEngine batchEngine, boolean exceptionsDisabled) {
        super(name);
        this.batchEngine = batchEngine;
        this.batchQueueManager = batchEngine.getBatchQueueManager();
        this.exceptionsDisabled = exceptionsDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(BatchJobInstanceAdapter jobInstance, BatchTransactionContext ctx, Record record) {
        ArrayList<Record> records = null;
        Map<BatchJobInstanceAdapter, Map<BatchTransactionContext, List<Record>>> map = this.buffer;
        synchronized (map) {
            records = (ArrayList<Record>)this.buffer.computeIfAbsent(jobInstance, k -> new HashMap()).get(ctx);
            if (records == null) {
                records = new ArrayList<Record>(this.batchEngine.getBlockSize(jobInstance));
                this.buffer.get(jobInstance).put(ctx, records);
            }
            records.add(record);
            if (ctx.getBlockSize() != records.size()) {
                return records.size();
            }
            this.buffer.get(jobInstance).remove(ctx);
        }
        this.doFlush(jobInstance, ctx, records);
        return records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(BatchJobInstanceAdapter jobInstance) {
        Map<BatchJobInstanceAdapter, Map<BatchTransactionContext, List<Record>>> map = this.buffer;
        synchronized (map) {
            this.doFlush(jobInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush(BatchJobInstanceAdapter jobInstance) {
        Map contexts = this.buffer.getOrDefault(jobInstance, new HashMap());
        try {
            for (Map.Entry entry : contexts.entrySet()) {
                BatchTransactionContext ctx = (BatchTransactionContext)entry.getKey();
                this.doFlush(jobInstance, ctx, (List)entry.getValue());
            }
        }
        finally {
            contexts.clear();
        }
    }

    protected void doFlush(BatchJobInstanceAdapter jobInstance, BatchTransactionContext ctx, List<Record> records) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Will flush %d records from instance %s of job %s", records.size(), jobInstance.getId(), jobInstance.getOwnerJobName()));
        }
        this.getDelegate(jobInstance).dispatchAndCommit(ctx, jobInstance, records, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(BatchJobInstanceAdapter jobInstance) {
        Map<BatchJobInstanceAdapter, Map<BatchTransactionContext, List<Record>>> map = this.buffer;
        synchronized (map) {
            this.doForget(jobInstance);
        }
    }

    protected void doForget(BatchJobInstanceAdapter jobInstance) {
        this.buffer.remove(jobInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushAndForget(BatchJobInstanceAdapter jobInstance) {
        Map<BatchJobInstanceAdapter, Map<BatchTransactionContext, List<Record>>> map = this.buffer;
        synchronized (map) {
            this.doFlush(jobInstance);
            this.doForget(jobInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(BatchJobInstanceAdapter jobInstance) {
        int size = 0;
        Map<BatchJobInstanceAdapter, Map<BatchTransactionContext, List<Record>>> map = this.buffer;
        synchronized (map) {
            Map<BatchTransactionContext, List<Record>> jobBuffer = this.buffer.get(jobInstance);
            if (jobBuffer != null) {
                for (List<Record> records : jobBuffer.values()) {
                    size += records.size();
                }
            }
            return size;
        }
    }

    protected abstract BatchQueueDelegate getDelegate(BatchJobInstanceAdapter var1);

    @Override
    public void commit(BatchTransactionContext context) {
        BatchUtils.commit(context);
    }

    @Override
    public void rollback(BatchTransactionContext ctx, BatchJobInstanceAdapter jobInstance, List<Record> records, MuleException e) {
        LOGGER.error(String.format("Could not queue %d records for instance '%s' of job '%s' on buffer '%s'. Records will be marked as failed. Processing block id is '%s'", records.size(), jobInstance.getId(), jobInstance.getOwnerJobName(), this.getName(), ctx.getId()), (Throwable)e);
        for (Record record : records) {
            BatchError error = BatchUtils.extractError((Exception)((Object)e));
            record.markAsFailedInStep(null, error);
            if (this.exceptionsDisabled) continue;
            record.markAsFailedInStep(null, (Exception)((Object)e));
        }
        try {
            this.batchEngine.updateStatisticsAndRoute(ctx, records);
        }
        catch (Exception e2) {
            LOGGER.error(String.format("Could not queue %d records for instance '%s' of job '%s' on buffer '%s'. To avoid record loss, they will be queued back. Processing block id is '%s'", records.size(), jobInstance.getId(), jobInstance.getOwnerJobName(), this.getName(), ctx.getId()), (Throwable)e2);
        }
        BatchUtils.rollback(ctx);
    }
}

