/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.api.record.RecordELAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.BufferUtils;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.RecordBuffer;
import com.mulesoft.mule.runtime.module.batch.internal.engine.transaction.BaseBatchTransactionContextWrapper;
import com.mulesoft.mule.runtime.module.batch.internal.engine.transaction.BatchTransactionContextProvider;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import java.util.Iterator;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.streaming.HasSize;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.Closeable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurer;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurerIterator;

public class StreamingAggregatorIteratorWrapper
implements EventBuilderConfigurerIterator<Object>,
HasSize,
Closeable {
    private final BatchTransactionContextProvider outputContextProvider;
    private final Iterator<List<Record>> delegate;
    private final BatchTransactionContext ctx;
    private final BatchJobInstanceAdapter jobInstance;
    private final RecordBuffer outputQueueBuffer;
    private final int blockSize;
    private final BatchTransactionContextProvider syncedOutputContextProvider = new BatchTransactionContextProvider(){

        @Override
        public BatchTransactionContext get(BatchJobInstanceAdapter jobInstance) {
            BatchTransactionContext txCtx = StreamingAggregatorIteratorWrapper.this.outputContextProvider.get(jobInstance);
            return new BaseBatchTransactionContextWrapper(txCtx){

                @Override
                public void commit() throws ResourceManagerException {
                    super.commit();
                    StreamingAggregatorIteratorWrapper.this.commit();
                    StreamingAggregatorIteratorWrapper.this.ctx.beginTransaction();
                }

                @Override
                public void rollback() throws ResourceManagerException {
                    super.rollback();
                    StreamingAggregatorIteratorWrapper.this.rollback();
                }
            };
        }
    };
    private Iterator<Record> block = null;
    private Pair<Record, RecordELAdapter> previous = null;

    public StreamingAggregatorIteratorWrapper(Iterator<List<Record>> delegate, BatchTransactionContextProvider outputContextProvider, BatchTransactionContext ctx, BatchJobInstanceAdapter jobInstance, RecordBuffer outputQueueBuffer, int blockSize) {
        this.delegate = delegate;
        this.outputContextProvider = outputContextProvider;
        this.ctx = ctx;
        this.jobInstance = jobInstance;
        this.outputQueueBuffer = outputQueueBuffer;
        this.blockSize = blockSize;
    }

    public boolean hasNext() {
        return this.block != null ? this.block.hasNext() : this.delegate.hasNext();
    }

    protected Pair<Record, RecordELAdapter> nextRecord() {
        if (this.block == null) {
            this.block = this.delegate.next().iterator();
        }
        Record record = this.block.next();
        if (!this.block.hasNext()) {
            this.block = null;
        }
        if (this.previous != null) {
            BufferUtils.addToBufferInSplitTransaction(this.jobInstance, this.outputQueueBuffer, null, this.syncedOutputContextProvider, (Record)this.previous.getFirst());
        }
        this.previous = new Pair((Object)record, (Object)new RecordELAdapter(record));
        return this.previous;
    }

    public Object next() {
        return ((Record)this.nextRecord().getFirst()).getPayload();
    }

    public EventBuilderConfigurer nextEventBuilderConfigurer() {
        final Pair<Record, RecordELAdapter> record = this.nextRecord();
        return new EventBuilderConfigurer(){

            public void configure(CoreEvent.Builder builder) {
                builder.message(Message.of(((Record)record.getFirst()).getPayload())).addVariable("record", record.getSecond());
                ((Record)record.getFirst()).getAllVariables().forEach((arg_0, arg_1) -> ((CoreEvent.Builder)builder).addVariable(arg_0, arg_1));
            }

            public void eventCompleted() {
                ((Record)record.getFirst()).updateWith((RecordELAdapter)record.getSecond());
            }
        };
    }

    public void close() throws MuleException {
        if (this.delegate instanceof Closeable) {
            ((Closeable)this.delegate).close();
        }
    }

    public void commit() {
        BatchUtils.commit(this.ctx);
    }

    public void rollback() {
        BatchUtils.rollback(this.ctx);
    }

    public void remove() {
        this.delegate.remove();
    }

    public int getSize() {
        if (this.delegate instanceof HasSize) {
            return ((HasSize)this.delegate).getSize() * this.blockSize;
        }
        return -1;
    }

    public Record getPrevious() {
        return this.previous != null ? (Record)this.previous.getFirst() : null;
    }
}

