/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.extension.error.BatchError;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.notification.BatchNotification;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.BatchProcessingTemplate;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.InMemoryRecordBuffer;
import com.mulesoft.mule.runtime.module.batch.reporting.StepErrorReporter;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.runtime.tracer.api.context.getter.MapDistributedTraceContextGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AggregatorRecordBuffer
extends InMemoryRecordBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregatorRecordBuffer.class);
    private final Processor chain;
    private final ComponentLocation location;
    protected final MuleContext muleContext;
    protected final BatchEngine batchEngine;
    protected final BatchStepAdapter step;
    protected StepErrorReporter errorReporter;
    protected final NotificationDispatcher notificationDispatcher;
    protected final EventTracer<CoreEvent> coreEventTracer;
    private final boolean exceptionsDisabled;

    public AggregatorRecordBuffer(String name, int size, BatchEngine batchEngine, BatchStepAdapter step, Processor chain, ComponentLocation location, NotificationDispatcher notificationDispatcher, MuleContext muleContext, EventTracer<CoreEvent> coreEventTracer, boolean exceptionsDisabled) {
        super(name, size);
        this.chain = chain;
        this.location = location;
        this.notificationDispatcher = notificationDispatcher;
        this.muleContext = muleContext;
        this.batchEngine = batchEngine;
        this.step = step;
        this.coreEventTracer = coreEventTracer;
        this.exceptionsDisabled = exceptionsDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFlush(BatchJobInstanceAdapter jobInstance, MultiMap<BatchTransactionContext, Record> records) {
        this.notificationDispatcher.dispatch((Notification)new BatchNotification((BatchJobInstance)jobInstance, this.step, BatchNotification.STEP_AGGREGATOR_START));
        CompletableFuture<Void> completion = new CompletableFuture<Void>();
        CoreEvent event = this.batchEngine.createEventBuilder(null, jobInstance, completion).build();
        this.coreEventTracer.injectDistributedTraceContext(event.getContext(), (DistributedTraceContextGetter)new MapDistributedTraceContextGetter(this.resolveAggregatorParentSpan()));
        try {
            event = this.configureChainEvent(event, jobInstance, records);
            if (event == null) {
                return;
            }
            this.makeProcessingTemplate(records, this.chain, this.muleContext).process(jobInstance, event, this.coreEventTracer);
        }
        catch (Exception e) {
            if (e.getCause() instanceof InterruptedException) {
                throw new MuleRuntimeException(e.getCause());
            }
            LOGGER.error(String.format("Exception found flushing %d records on buffer %s", records.size(), this.getName()), (Throwable)e);
        }
        finally {
            records.valuesList().forEach(r -> r.getCompletionCallback().decrementConsumers());
            completion.complete(null);
        }
    }

    private Map<String, String> resolveAggregatorParentSpan() {
        return this.step.getSerializedBatchStepSpan();
    }

    protected abstract CoreEvent configureChainEvent(CoreEvent var1, BatchJobInstanceAdapter var2, MultiMap<BatchTransactionContext, Record> var3) throws MuleException;

    protected abstract BatchProcessingTemplate makeProcessingTemplate(MultiMap<BatchTransactionContext, Record> var1, Processor var2, MuleContext var3);

    protected void markError(BatchJobInstanceAdapter jobInstance, List<Record> records, Exception e) {
        BatchError error = BatchUtils.extractError(e);
        this.errorReporter.report(jobInstance, error);
        for (Record record : records) {
            record.markAsFailedInStep((BatchStep)this.step, error);
            if (this.exceptionsDisabled) continue;
            record.markAsFailedInStep((BatchStep)this.step, e);
        }
        this.notificationDispatcher.dispatch((Notification)new BatchNotification((BatchJobInstance)jobInstance, (BatchStep)this.step, e, BatchNotification.STEP_AGGREGATOR_FAILED));
    }

    public void setErrorReporter(StepErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    protected ComponentLocation getLocation() {
        return this.location;
    }
}

