/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine;

import com.mulesoft.mule.runtime.module.batch.BatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchRecordDispatcher;
import com.mulesoft.mule.runtime.module.batch.internal.engine.BatchRecordDispatcherDelegate;
import com.mulesoft.mule.runtime.module.batch.internal.engine.threading.BatchWorkManager;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;

public class DefaultBatchRecordDispatcher
implements BatchRecordDispatcher {
    public static final String BATCH_DISPATCHER_THREAD_NAME = "Batch Dispatcher";
    private final Scheduler scheduler;
    private final BatchRecordDispatcherDelegate delegate;
    private ScheduledFuture<?> dispatcherWork;
    private NotificationListenerRegistry notificationListenerRegistry;

    public DefaultBatchRecordDispatcher(BatchEngine batchEngine, BatchWorkManager workManager, SchedulerService schedulerService, SchedulerConfig schedulerBaseConfig, NotificationListenerRegistry notificationListenerRegistry) {
        this.scheduler = schedulerService.ioScheduler(schedulerBaseConfig.withName(BATCH_DISPATCHER_THREAD_NAME));
        this.delegate = new BatchRecordDispatcherDelegate(batchEngine, workManager);
        this.notificationListenerRegistry = notificationListenerRegistry;
    }

    @Override
    public void start() {
        this.registerShutdownListener();
        this.dispatcherWork = this.scheduler.scheduleWithFixedDelay((Runnable)this.delegate, 0L, 1L, TimeUnit.MILLISECONDS);
    }

    private void registerShutdownListener() {
        this.notificationListenerRegistry.registerListener((NotificationListener)new MuleContextNotificationListener<MuleContextNotification>(){

            public void onNotification(MuleContextNotification notification) {
                if (notification.getAction().getActionId() == 105) {
                    DefaultBatchRecordDispatcher.this.delegate.stop();
                    DefaultBatchRecordDispatcher.this.notificationListenerRegistry.unregisterListener((NotificationListener)this);
                }
            }
        });
    }

    @Override
    public void stop() {
        this.dispatcherWork.cancel(true);
        this.scheduler.stop();
    }

    @Override
    public BatchProcessingListener getListener() {
        return this.delegate.getListener();
    }
}

