/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine;

import com.mulesoft.mule.runtime.module.batch.BatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstanceStatus;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.BaseBatchProcessingListener;
import com.mulesoft.mule.runtime.module.batch.internal.engine.threading.BatchJobInstanceTerminatorWork;
import com.mulesoft.mule.runtime.module.batch.internal.engine.threading.BatchRecordWork;
import com.mulesoft.mule.runtime.module.batch.internal.engine.threading.BatchWorkManager;
import com.mulesoft.mule.runtime.module.batch.util.BatchUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRecordDispatcherDelegate
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchRecordDispatcherDelegate.class);
    private final BatchEngine batchEngine;
    private final BatchWorkManager workManager;
    private final BatchProcessingListener listener = new Listener();
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private Latch latch = new Latch();

    public BatchRecordDispatcherDelegate(BatchEngine batchEngine, BatchWorkManager workManager) {
        this.batchEngine = batchEngine;
        this.workManager = workManager;
    }

    @Override
    public void run() {
        if (this.stopping.get()) {
            return;
        }
        Map<BatchJobAdapter, List<BatchJobInstance>> executableInstances = null;
        try {
            executableInstances = this.getExecutableJobInstances();
        }
        catch (MuleException e) {
            this.handleCouldNotGetInstance((Exception)((Object)e));
        }
        boolean dispatchedRecords = false;
        if (executableInstances != null) {
            dispatchedRecords = this.dispatch(executableInstances);
        }
        if (this.stopping.get()) {
            return;
        }
        if (!(dispatchedRecords || Thread.currentThread().isInterrupted() || this.await())) {
            this.releaseLatch();
        }
    }

    private boolean areAllRecordsProcessed(BatchJobInstance jobInstance) {
        return jobInstance.getResult().getProcessedRecords() >= jobInstance.getResult().getTotalRecords();
    }

    private boolean dispatch(Map<BatchJobAdapter, List<BatchJobInstance>> executableInstances) {
        boolean recordsDispatched = false;
        for (Map.Entry<BatchJobAdapter, List<BatchJobInstance>> entry : executableInstances.entrySet()) {
            BatchJobAdapter batchJob = entry.getKey();
            BatchJobInstance jobInstance = null;
            try {
                jobInstance = batchJob.getBatchJobInstanceSchedulingStrategy().next(entry.getValue());
            }
            catch (Exception e) {
                this.handleCouldNotGetInstance(e);
            }
            if (jobInstance == null) continue;
            try {
                recordsDispatched = this.dispatch(batchJob, (BatchJobInstanceAdapter)jobInstance);
                if (recordsDispatched || !this.areAllRecordsProcessed(jobInstance)) continue;
                BatchJobInstanceTerminatorWork work = new BatchJobInstanceTerminatorWork(this.batchEngine, (BatchJobInstanceAdapter)jobInstance);
                this.workManager.scheduleManagementWork(work);
            }
            catch (RejectedExecutionException e) {
                LOGGER.error(String.format("Could not dispatch instance '%s' of batch job '%s'.", jobInstance.getId(), jobInstance.getOwnerJobName()), (Throwable)e);
                entry.getValue().remove(jobInstance);
            }
        }
        return recordsDispatched;
    }

    private boolean dispatch(BatchJobAdapter job, BatchJobInstanceAdapter jobInstance) {
        block7: {
            if (BatchJobInstanceStatus.EXECUTING.equals((Object)jobInstance.getStatus())) {
                this.workManager.executable(jobInstance);
            }
            BatchTransactionContext ctx = this.batchEngine.createTransactionContext(jobInstance);
            List<Record> block = null;
            try {
                ctx.beginTransaction();
                block = this.batchEngine.getBlockFrom(ctx);
                if (block != null && !block.isEmpty()) {
                    BatchRecordWork work = new BatchRecordWork(this.batchEngine, job, ctx, this.listener, block);
                    if (!this.stopping.get()) {
                        this.workManager.scheduleRecordWork(ctx, work);
                        return true;
                    }
                } else {
                    ctx.commit();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Found no records for instance '%s' of batch job '%s'", jobInstance.getId(), jobInstance.getOwnerJobName()));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(String.format("Could not dispatch block '%s' for instance '%s' of batch job '%s'. Records will be queued back ", ctx.getId(), jobInstance.getId(), jobInstance.getOwnerJobName()), (Throwable)e);
                if (block == null) break block7;
                BatchUtils.completeWorkOnBlock(block, true, this.listener, ctx);
            }
        }
        return false;
    }

    public void stop() {
        this.stopping.set(true);
        this.latch.release();
    }

    private Map<BatchJobAdapter, List<BatchJobInstance>> getExecutableJobInstances() throws MuleException {
        List elegibleInstances = this.batchEngine.getJobInstanceStore().getExecutingInstances();
        if (elegibleInstances == null || elegibleInstances.isEmpty()) {
            return null;
        }
        HashMap<BatchJobAdapter, List<BatchJobInstance>> result = new HashMap<BatchJobAdapter, List<BatchJobInstance>>(elegibleInstances.size());
        for (BatchJobInstance jobInstance : elegibleInstances) {
            BatchJobAdapter batchJob = this.batchEngine.getJobFor(jobInstance);
            ArrayList<BatchJobInstance> executables = (ArrayList<BatchJobInstance>)result.get(batchJob);
            if (executables == null) {
                executables = new ArrayList<BatchJobInstance>();
                result.put(batchJob, executables);
            }
            executables.add(jobInstance);
        }
        return result;
    }

    private void releaseLatch() {
        this.latch.release();
    }

    private boolean await() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BatchDispatcher thread could not find work. Suspending until stepping queue shows activity");
        }
        try {
            this.latch.await();
            this.latch = new Latch();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("BatchDispatcher thread received signal from stepping queue. Waking up");
            }
        }
        catch (InterruptedException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Batch Dispatcher Thread was interrupted while waiting for stepping queue events. Stopping the thread now");
            }
            return false;
        }
        return true;
    }

    public BatchProcessingListener getListener() {
        return this.listener;
    }

    private void handleCouldNotGetInstance(Exception e) {
        LOGGER.error("Exception found while trying to get an executing batch instance", (Throwable)e);
    }

    private class Listener
    extends BaseBatchProcessingListener {
        private Listener() {
        }

        @Override
        public void onSteppingQueueDispatch(BatchJobInstanceAdapter jobInstance, Collection<Record> records) {
            BatchRecordDispatcherDelegate.this.releaseLatch();
        }

        @Override
        public void onJobInstanceStateChange(BatchJobInstanceAdapter jobInstance) {
            BatchRecordDispatcherDelegate.this.releaseLatch();
        }
    }
}

