/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal;

import com.mulesoft.mule.runtime.module.batch.api.extension.error.BatchError;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepErrorSummary;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepExceptionSummary;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepResult;
import com.mulesoft.mule.runtime.module.batch.internal.BatchStepErrorSummaryAdapter;
import com.mulesoft.mule.runtime.module.batch.internal.DefaultBatchStepErrorSummary;
import com.mulesoft.mule.runtime.module.batch.internal.DefaultBatchStepExceptionSummary;

public class DefaultBatchStepResult
implements BatchStepResult {
    private static final long serialVersionUID = 1199467117865243013L;
    private long successfulRecords = 0L;
    private long failedRecords = 0L;
    private long receivedRecords = 0L;
    private BatchStepErrorSummaryAdapter errorSummary = new DefaultBatchStepErrorSummary();

    public DefaultBatchStepResult() {
    }

    public DefaultBatchStepResult(long receivedRecords, long successfulRecords, long failedRecords, BatchStepErrorSummary errorSummary) {
        this.receivedRecords = receivedRecords;
        this.successfulRecords = successfulRecords;
        this.failedRecords = failedRecords;
        this.errorSummary = (BatchStepErrorSummaryAdapter)errorSummary;
    }

    public long incrementSuccessfulRecords(long howMany) {
        return this.successfulRecords += howMany;
    }

    public long incrementFailedRecords(BatchError error, long howMany) {
        this.errorSummary.account(error);
        return this.failedRecords += howMany;
    }

    public long incrementReceivedRecords(long howMany) {
        return this.receivedRecords += howMany;
    }

    public long getReceivedRecords() {
        return this.receivedRecords;
    }

    public long getSuccessfulRecords() {
        return this.successfulRecords;
    }

    public long getFailedRecords() {
        return this.failedRecords;
    }

    public BatchStepExceptionSummary getExceptionSummary() {
        return new DefaultBatchStepExceptionSummary();
    }

    public BatchStepErrorSummary getErrorSummary() {
        return this.errorSummary;
    }
}

