/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal;

import com.mulesoft.mule.runtime.module.batch.api.extension.error.BatchError;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepResult;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.internal.BatchJobResultAdapter;
import com.mulesoft.mule.runtime.module.batch.internal.DefaultBatchStepResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultBatchJobResult
implements BatchJobResultAdapter {
    private static final long serialVersionUID = 8915213037073563516L;
    private final String batchJodInstanceId;
    private long totalRecords = 0L;
    private long successfulRecords = 0L;
    private long failedRecords = 0L;
    private long loadedRecords = 0L;
    private long processedRecords = 0L;
    private long processStartTime = 0L;
    private long totalRunningTime = 0L;
    private final Map<String, DefaultBatchStepResult> batchStepResults;
    private BatchError inputPhaseError;
    private BatchError loadingPhaseError;
    private BatchError onCompletePhaseError;

    public DefaultBatchJobResult(String batchJodInstanceId) {
        this.batchJodInstanceId = batchJodInstanceId;
        this.batchStepResults = new HashMap<String, DefaultBatchStepResult>();
    }

    public DefaultBatchJobResult(String batchJodInstanceId, long totalRecords, long successfulRecords, long failedRecords, long loadedRecords, long processedRecords, long processStartTime, long totalRunningTime, Map<String, DefaultBatchStepResult> batchStepResults, BatchError inputPhaseError, BatchError loadingPhaseError, BatchError onCompletePhaseError) {
        this.batchJodInstanceId = batchJodInstanceId;
        this.totalRecords = totalRecords;
        this.successfulRecords = successfulRecords;
        this.failedRecords = failedRecords;
        this.loadedRecords = loadedRecords;
        this.processedRecords = processedRecords;
        this.processStartTime = processStartTime;
        this.totalRunningTime = totalRunningTime;
        this.batchStepResults = batchStepResults != null ? batchStepResults : new HashMap();
        this.inputPhaseError = inputPhaseError;
        this.loadingPhaseError = loadingPhaseError;
        this.onCompletePhaseError = onCompletePhaseError;
    }

    @Override
    public void updateFor(BatchJobAdapter job, Collection<Record> records) {
        for (Record record : records) {
            BatchStepAdapter step = job.getStepById(record.getCurrentStepId());
            DefaultBatchStepResult result = (DefaultBatchStepResult)this.getResultForStep(step.getName());
            result.incrementReceivedRecords(1L);
            BatchError error = record.getErrorForStep(step.getName());
            if (error != null) {
                result.incrementFailedRecords(error, 1L);
                if (record.getFailedStepsCount() == 1) {
                    ++this.failedRecords;
                }
            } else {
                result.incrementSuccessfulRecords(1L);
            }
            if (!step.isLast()) continue;
            ++this.processedRecords;
            if (record.hasErrors()) continue;
            ++this.successfulRecords;
        }
    }

    public BatchStepResult getResultForStep(String stepId) {
        DefaultBatchStepResult result = this.batchStepResults.get(stepId);
        if (result == null) {
            result = new DefaultBatchStepResult();
            this.batchStepResults.put(stepId, result);
        }
        return result;
    }

    @Override
    public long startClock() {
        this.processStartTime = System.currentTimeMillis();
        return this.processStartTime;
    }

    @Override
    public long stopClock() {
        return this.totalRunningTime += System.currentTimeMillis() - this.processStartTime;
    }

    public long getElapsedTimeInMillis() {
        return this.totalRunningTime;
    }

    public long getSuccessfulRecords() {
        return this.successfulRecords;
    }

    public long getFailedRecords() {
        return this.failedRecords;
    }

    public long getProcessedRecords() {
        return this.processedRecords;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public String getBatchJobInstanceId() {
        return this.batchJodInstanceId;
    }

    public long getLoadedRecords() {
        return this.loadedRecords;
    }

    @Override
    public long incrementLoadedRecords(long howMany) {
        return this.loadedRecords += howMany;
    }

    @Override
    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public boolean isFailedOnInputPhase() {
        return this.inputPhaseError != null;
    }

    public Exception getInputPhaseException() {
        return null;
    }

    public BatchError getInputPhaseError() {
        return this.inputPhaseError;
    }

    public Exception getLoadingPhaseException() {
        return null;
    }

    public BatchError getLoadingPhaseError() {
        return this.loadingPhaseError;
    }

    public boolean isFailedOnLoadingPhase() {
        return this.loadingPhaseError != null;
    }

    public boolean isFailedOnCompletePhase() {
        return this.onCompletePhaseError != null;
    }

    public Exception getOnCompletePhaseException() {
        return null;
    }

    public BatchError getOnCompletePhaseError() {
        return this.onCompletePhaseError;
    }

    @Override
    public void setInputPhaseError(BatchError inputPhaseError) {
        this.inputPhaseError = inputPhaseError;
    }

    @Override
    public void setLoadingPhaseError(BatchError loadingPhaseError) {
        this.loadingPhaseError = loadingPhaseError;
    }

    @Override
    public void setOnCompletePhaseError(BatchError onCompletePhaseError) {
        this.onCompletePhaseError = onCompletePhaseError;
    }

    @Override
    public Map<String, BatchStepResult> getBatchStepResults() {
        return Collections.unmodifiableMap(this.batchStepResults);
    }
}

