/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.troubleshooting.plugin.mbean;

import com.mulesoft.mule.troubleshooting.plugin.mbean.TroubleshootingMBean;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationException;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingService;

public class Troubleshooting
implements TroubleshootingMBean {
    private final TroubleshootingService troubleshootingService;

    public Troubleshooting(TroubleshootingService troubleshootingService) {
        this.troubleshootingService = troubleshootingService;
    }

    @Override
    public List<TroubleshootingOperationDefinition> retrieveAvailableOperations() {
        return this.troubleshootingService.getAvailableOperations();
    }

    @Override
    public Object executeOperation(String operationName, Map<String, String> arguments) throws TroubleshootingOperationException {
        return this.troubleshootingService.executeOperation(operationName, arguments);
    }

    @Override
    public Object executeAllOperations(Map<String, String> arguments) throws TroubleshootingOperationException {
        return this.troubleshootingService.executeAllOperations(arguments);
    }

    @Override
    public String invokeThreadDump() {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("com.sun.management:type=DiagnosticCommand");
            Object[] commandArgs = new Object[]{new String[0]};
            String[] signature = new String[]{String[].class.getName()};
            return (String)mbeanServer.invoke(objectName, "threadPrint", commandArgs, signature);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get thread dump", e);
        }
    }

    @Override
    public String invokeHeapDump() {
        try {
            HotSpotDiagnosticMXBean mxBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
            Path tempFile = Files.createTempFile("heap_dump_", ".hprof", new FileAttribute[0]);
            Files.deleteIfExists(tempFile);
            mxBean.dumpHeap(tempFile.toString(), true);
            return tempFile.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get heap dump: " + e.getMessage(), e);
        }
    }
}

