/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.troubleshooting.plugin;

import com.mulesoft.mule.troubleshooting.plugin.BaseMulePlugin;
import com.mulesoft.mule.troubleshooting.plugin.mbean.Troubleshooting;
import java.lang.management.ManagementFactory;
import javax.inject.Inject;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TroubleshootingPlugin
extends BaseMulePlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(TroubleshootingPlugin.class);
    @Inject
    private TroubleshootingService troubleshootingService;

    @Override
    public void start() {
        this.registerTroubleshootingBean(new Troubleshooting(this.troubleshootingService));
    }

    private void registerTroubleshootingBean(Troubleshooting mBean) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.registerMBean(mBean, this.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            LOGGER.error("Error creating object name", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            LOGGER.error("Error registering MBean", (Throwable)e);
        }
    }

    private ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName(String.format("%s:type=%s", this.getClass().getPackage().getName(), Troubleshooting.class.getName()));
    }
}

