/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;

public class Request {
    private String rootSource;
    private String method = "GET";
    private String resource;
    private String[] acceptedTypes = new String[0];
    private String type = "application/json";
    private Map<String, String> queryParams = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Object body;

    public void setAcceptedTypes(String ... acceptedTypes) {
        this.acceptedTypes = acceptedTypes;
    }

    public String getMethod() {
        return this.method;
    }

    public String getResource() {
        return this.resource;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getBody() {
        return this.body;
    }

    public String[] getAcceptedTypes() {
        return this.acceptedTypes;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setQueryParams(Map<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getRootSource() {
        return this.rootSource == null ? "" : this.rootSource;
    }

    public void setRootSource(String rootSource) {
        this.rootSource = rootSource;
    }

    public void resolveResourceTemplate(Map<String, String> params) throws UnsupportedEncodingException {
        if (this.resource == null) {
            throw new IllegalStateException("There is no resource template defined.");
        }
        StrSubstitutor sub = new StrSubstitutor(this.encodeValues(params), "{", "}");
        this.resource = sub.replace(this.resource);
    }

    private Map encodeValues(Map<String, String> params) throws UnsupportedEncodingException {
        HashMap<String, String> encodedMap = new HashMap<String, String>();
        for (String key : params.keySet()) {
            encodedMap.put(key, URLEncoder.encode(params.get(key), "UTF-8"));
        }
        return encodedMap;
    }
}

