/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.MuleModuleVersionComparator;
import org.mule.tooling.ui.palette.AddModulesHelper;
import org.mule.tooling.ui.properties.IDependencyManager;
import org.mule.tooling.ui.properties.ModuleDependencyManager;
import org.mule.tooling.ui.properties.ModuleWizardMode;
import org.mule.tooling.ui.properties.dependencies.AddDependencyWizardDialog;
import org.mule.tooling.ui.properties.dependencies.WizardDependencyMode;

public class SelectModuleVersionDialog
extends Dialog {
    private static final String SEARCH_IN_EXCHANGE_LINK_TEXT = "If the version you need is not listed, we suggest you try to <a>Add Module from Exchange</a>.";
    private static final String VERSION_SELECTION_LABEL = "Version:";
    private static final String DESCRIPTION = "Select which of the available versions in the Workspace you want to add in your project.";
    private static final String ADD_MODULE_CONFIRM_TEXT = "Add";
    private final IMuleProject muleProject;
    private final List<ExternalContributionMuleModule> availableModules;
    private ExternalContributionMuleModule selectedModule;

    public SelectModuleVersionDialog(Shell parentShell, IMuleProject muleProject, List<ExternalContributionMuleModule> availableModules) {
        super(parentShell);
        this.muleProject = muleProject;
        this.availableModules = availableModules;
        Collections.sort(availableModules, MuleModuleVersionComparator.descendingVersion());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select module version");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.addDescriptionMessage(composite);
        this.addVersionSelector(composite);
        this.addExchangeLink(composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.getButton(0).setText(ADD_MODULE_CONFIRM_TEXT);
        return createButtonBar;
    }

    private void addDescriptionMessage(Composite composite) {
        Label description = new Label(composite, 0);
        description.setText(DESCRIPTION);
    }

    private void addVersionSelector(Composite composite) {
        Composite container = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        Label description = new Label(container, 0);
        description.setText(VERSION_SELECTION_LABEL);
        ComboViewer versionsCombo = new ComboViewer(container, 8);
        versionsCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        versionsCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ExternalContributionMuleModule) {
                    ExternalContributionMuleModule module = (ExternalContributionMuleModule)element;
                    return module.getVersion();
                }
                return super.getText(element);
            }
        });
        versionsCombo.setInput(this.availableModules);
        versionsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    SelectModuleVersionDialog.this.setSelectedModule((ExternalContributionMuleModule)selection.getFirstElement());
                }
            }
        });
        versionsCombo.setSelection((ISelection)new StructuredSelection((Object)this.availableModules.get(0)));
    }

    private void addExchangeLink(Composite composite) {
        Link searchInExchange = new Link(composite, 0);
        searchInExchange.setText(SEARCH_IN_EXCHANGE_LINK_TEXT);
        searchInExchange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectModuleVersionDialog.this.cancelPressed();
                Display.getDefault().asyncExec(() -> AddModulesHelper.create(SelectModuleVersionDialog.this.muleProject, () -> {
                    AddDependencyWizardDialog dialog = AddDependencyWizardDialog.create((Shell)Display.getCurrent().getActiveShell(), (WizardDependencyMode)new ModuleWizardMode((IDependencyManager)new ModuleDependencyManager(SelectModuleVersionDialog.this.muleProject)));
                    if (dialog.open() == 0) {
                        return dialog.getResult();
                    }
                    return Collections.emptyList();
                }).addModules());
            }
        });
    }

    public ExternalContributionMuleModule getSelectedModule() {
        return this.selectedModule;
    }

    public void setSelectedModule(ExternalContributionMuleModule selectedModule) {
        this.selectedModule = selectedModule;
    }
}

