/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import java.util.Arrays;
import java.util.List;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.messageflow.editor.InterruptibleCreationTool;
import org.mule.tooling.ui.internal.palette.view.SWTHelper;
import org.mule.tooling.ui.palette.core.NodeDefinitionPaletteEntry;
import org.mule.tooling.ui.palette.core.SearchResult;
import org.mule.tooling.ui.palette.utils.PaletteHelper;
import org.mule.tooling.ui.palette.view.EntityTemplateTransferDragSourceListener;
import org.mule.tooling.ui.palette.view.OperationsViewer;
import org.mule.tooling.ui.palette.view.PaletteState;
import org.mule.tooling.ui.palette.view.SearchResultLabelProvider;

public class SearchResultViewer
extends Viewer {
    private final TableViewer tableViewer;
    private final TableViewerColumn column;
    private EditDomain editDomain;
    private EntityTemplateTransferDragSourceListener dragListener;

    public SearchResultViewer(Composite parent, int style, PaletteState paletteState, Runnable onAddModules) {
        Composite tableComposite = new Composite(parent, 0);
        this.tableViewer = new TableViewer(tableComposite, style);
        Cursor handCursor = Display.getDefault().getSystemCursor(21);
        this.tableViewer.getControl().setCursor(handCursor);
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        this.dragListener = new EntityTemplateTransferDragSourceListener(this.tableViewer, paletteState);
        this.tableViewer.addDragSupport(3, transfers, (DragSourceListener)this.dragListener);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.column = new TableViewerColumn(this.tableViewer, 0);
        this.column.getColumn().setResizable(false);
        TableColumnLayout layout = new TableColumnLayout();
        layout.setColumnData((Widget)this.column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        tableComposite.setLayout((Layout)layout);
        this.column.setLabelProvider((CellLabelProvider)new SearchResultLabelProvider(paletteState));
        this.tableViewer.getTable().addMouseListener(MouseListener.mouseUpAdapter(this::onMouseUp));
        this.tableViewer.addSelectionChangedListener(e -> {
            IStructuredSelection structuredSelection;
            Object firstElement;
            ISelection selection = e.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) == SearchResult.EMPTY) {
                onAddModules.run();
            }
        });
        this.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    SearchResultViewer.this.editDomain.setActiveTool(SearchResultViewer.this.editDomain.getDefaultTool());
                }
            }
        });
        this.tableViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (SearchResultViewer.this.tableViewer.getSelection().isEmpty()) {
                    SearchResultViewer.this.focusFirstItem();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.createMenu();
    }

    private void onMouseUp(MouseEvent event) {
        IStructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = this.tableViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != SearchResult.EMPTY) {
            SearchResult entry = (SearchResult)firstElement;
            ViewerCell selectedTableItem = this.tableViewer.getCell(new Point(event.x, event.y));
            if (selectedTableItem != null && entry.equals(selectedTableItem.getElement())) {
                CreationFactory template = PaletteHelper.createFactory(entry.getNode().getNodeDefinition(), entry.getAvailableModules());
                InterruptibleCreationTool.getInstance().setFactory(template);
                this.editDomain.setActiveTool((Tool)InterruptibleCreationTool.getInstance());
            }
        }
    }

    public Control getControl() {
        return this.tableViewer.getControl();
    }

    public Object getInput() {
        return this.tableViewer.getInput();
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public void setInput(Object input) {
        if (input instanceof List) {
            List results = (List)input;
            SWTHelper.clearSelectedRowIndexFieldValue(this.tableViewer.getTable());
            if (!results.isEmpty()) {
                this.tableViewer.setInput(input);
            } else {
                this.tableViewer.setInput(Arrays.asList(SearchResult.EMPTY));
            }
        } else {
            throw new IllegalArgumentException("input should be a List<SearchResult>");
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.tableViewer.setSelection(selection, reveal);
    }

    public void addFilter(ViewerFilter filter) {
        this.tableViewer.addFilter(filter);
    }

    public void focusFirstItem() {
        Object elementAt = this.tableViewer.getElementAt(0);
        if (elementAt != null) {
            this.tableViewer.getControl().setFocus();
            this.tableViewer.setSelection((ISelection)new StructuredSelection(elementAt), true);
        }
    }

    public void setEditDomain(EditDomain editDomain) {
        this.editDomain = editDomain;
        this.dragListener.setEditDomain(editDomain);
    }

    public void createMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                Object object;
                if (SearchResultViewer.this.tableViewer.getSelection().isEmpty()) {
                    return;
                }
                if (SearchResultViewer.this.tableViewer.getSelection() instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)SearchResultViewer.this.tableViewer.getSelection()).getFirstElement()) instanceof SearchResult) {
                    NodeDefinitionPaletteEntry node = ((SearchResult)object).getNode();
                    OperationsViewer.createActions(manager, node);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getControl().setMenu(menu);
    }
}

