/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.mule.tooling.ui.palette.PalettePlugin;
import org.mule.tooling.ui.palette.core.SearchResult;
import org.mule.tooling.ui.palette.view.PaletteState;
import org.mule.tooling.ui.palette.view.TooltipFactory;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class SearchResultLabelProvider
extends StyledCellLabelProvider {
    private static final String FONT_KEY = "org.mule.tooling.PALETTE_SEARCH_RESULTS_FONT";
    private static final int SPACING = 5;
    private final PaletteState paletteState;

    public SearchResultLabelProvider(PaletteState paletteState) {
        this.paletteState = paletteState;
    }

    protected void measure(Event event, Object element) {
        event.height = 20;
    }

    protected void paint(Event event, Object element) {
        SearchResult result = (SearchResult)element;
        if (result != null) {
            int textDelta;
            Point textLength;
            Rectangle tableCellBounds = ((TableItem)event.item).getBounds(event.index);
            Font originalFont = event.gc.getFont();
            if (!JFaceResources.getFontRegistry().hasValueFor(FONT_KEY)) {
                JFaceResources.getFontRegistry().put(FONT_KEY, originalFont.getFontData());
            }
            event.gc.setForeground(ThemeUtils.getCurrentTheme().getForegroundColor());
            Image groupIcon = result.getMainIcon();
            int delta = 20 - groupIcon.getBounds().height >>> 1;
            int yCoords = tableCellBounds.y + delta;
            int xCoord = tableCellBounds.x + 5;
            if (PaletteState.Mode.ALL.equals((Object)this.paletteState.getMode()) || PaletteState.Mode.LOCAL.equals((Object)this.paletteState.getMode()) || result.isEmptyResult()) {
                event.gc.drawImage(groupIcon, xCoord, yCoords);
                xCoord += 5;
                String groupLabel = result.getMainText();
                textLength = event.gc.stringExtent(groupLabel);
                textDelta = 20 - textLength.y >>> 1;
                Font boldFont = JFaceResources.getFontRegistry().getBold(FONT_KEY);
                event.gc.setFont(boldFont);
                event.gc.drawString(groupLabel, xCoord += groupIcon.getBounds().width, tableCellBounds.y + textDelta, true);
                xCoord += 5;
                Image separator = PalettePlugin.getDefault().getSeparatorImage();
                int delta2 = 20 - separator.getBounds().height >>> 1;
                int ySeparatorCoords = tableCellBounds.y + delta2;
                event.gc.drawImage(separator, xCoord += textLength.x, ySeparatorCoords);
                xCoord += 5 + separator.getBounds().width;
            }
            xCoord += this.drawDetailIcon(event, result, yCoords, xCoord);
            event.gc.setFont(originalFont);
            String nodeLabel = result.getDetailText();
            textLength = event.gc.stringExtent(nodeLabel);
            textDelta = 20 - textLength.y >>> 1;
            event.gc.drawText(nodeLabel, xCoord, tableCellBounds.y + textDelta, true);
        }
    }

    private int drawDetailIcon(Event event, SearchResult result, int yCoords, int xCoord) {
        return result.getDetailIcon().map(nodeIcon -> {
            event.gc.drawImage(nodeIcon, xCoord, yCoords);
            return 5 + nodeIcon.getBounds().width;
        }).orElse(0);
    }

    public String getToolTipText(Object element) {
        if (element instanceof SearchResult) {
            SearchResult item = (SearchResult)element;
            String tooltip = TooltipFactory.createTooltip(item.getTooltip());
            return tooltip.length() == 0 ? null : tooltip;
        }
        return null;
    }
}

