/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import com.google.common.base.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleModuleManagerRestartedListener;
import org.mule.tooling.core.event.IMuleRuntimeChangedListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.ui.palette.DisabledPalettePage;
import org.mule.tooling.ui.palette.ISearchHandler;
import org.mule.tooling.ui.palette.PalettePlugin;
import org.mule.tooling.ui.palette.view.PalettePage;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class PaletteView
extends PageBookView {
    private static final Path SRC_TEST_PATH = new Path("src/test");
    public static final String ID = "org.mule.tooling.ui.palette.PaletteView";
    private EventBusHelper eventBusHelper = new EventBusHelper();
    private ISearchHandler searchHandler;
    private boolean runtimeChanged;
    private boolean moduleManagerChanged;
    private IPageChangedListener pageChangedListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            if (PaletteView.this.defalultPageIsSet()) {
                IWorkbenchPart selectedPage = (IWorkbenchPart)event.getSelectedPage();
                PaletteView.this.partActivated(selectedPage);
            }
        }
    };
    private boolean isBeingForced = false;

    public PaletteView() {
        this.registerListeners();
    }

    private void registerListeners() {
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_RUNTIME_CHANGED, (IEventHandler)new IMuleRuntimeChangedListener(){

            public void beforeChanging(String fromId, String toId, IMuleProject muleProject) {
            }

            public void afterChanging(String fromId, String toId, IMuleProject muleProject) {
                PaletteView.this.runtimeChanged = true;
            }
        });
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_MODULE_MANAGER_RESTARTED, (IEventHandler)((IMuleModuleManagerRestartedListener)manager -> {
            this.moduleManagerChanged = true;
        }));
    }

    protected IPage createDefaultPage(PageBook book) {
        return this.createEmptyDefaultPage(book);
    }

    private DisabledPalettePage createEmptyDefaultPage(PageBook book) {
        DisabledPalettePage messagePage = new DisabledPalettePage();
        this.initPage((IPageBookViewPage)messagePage);
        messagePage.createControl((Composite)book);
        return messagePage;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof MessageFlowEditor && !((MessageFlowEditor)part).isReadOnly()) {
            return this.createPalettePageRec((MessageFlowEditor)part);
        }
        if (part instanceof MultiPageMessageFlowEditor) {
            MultiPageMessageFlowEditor multiPageMessageFlowEditor = (MultiPageMessageFlowEditor)part;
            if (this.isFlowEditorActive(multiPageMessageFlowEditor)) {
                return this.createPalettePageRec((MessageFlowEditor)multiPageMessageFlowEditor.getActiveEditor());
            }
            return new PageBookView.PageRec((IWorkbenchPart)multiPageMessageFlowEditor.getActiveEditor(), this.getDefaultPage());
        }
        return new PageBookView.PageRec(part, this.getDefaultPage());
    }

    private PageBookView.PageRec createPalettePageRec(MessageFlowEditor messageFlowEditor) {
        PalettePage palettePage = new PalettePage(this.isTestFolder(messageFlowEditor));
        this.initPage((IPageBookViewPage)palettePage);
        palettePage.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec((IWorkbenchPart)messageFlowEditor, (IPage)palettePage);
    }

    private boolean isTestFolder(MessageFlowEditor messageFlowEditor) {
        IMuleProject project = messageFlowEditor.getMuleProject();
        IFile xmlConfigFile = messageFlowEditor.getInputXmlConfigFile();
        return project != null && xmlConfigFile != null ? new Path(project.getName()).append((IPath)SRC_TEST_PATH).isPrefixOf(xmlConfigFile.getFullPath()) : false;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
        MultiPageMessageFlowEditor asMultiPageEditor = this.getMultiPageMessageFlowEditor(part);
        if (asMultiPageEditor != null) {
            asMultiPageEditor.removePageChangedListener(this.pageChangedListener);
        }
        this.getSite().setSelectionProvider(null);
    }

    private boolean isFlowEditorActive(MultiPageMessageFlowEditor multiPageMessageFlowEditor) {
        return multiPageMessageFlowEditor.getCurentPageIndex() == multiPageMessageFlowEditor.getFlowEditorIndex();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            IWorkbenchPart activePart = page.getActivePart();
            if (this.isImportant(activePart)) {
                return activePart;
            }
            MultiPageMessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getMultiPageMessageFlowEditor();
            if (flowEditorFromActivePage != null) {
                return flowEditorFromActivePage.getActiveEditor();
            }
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return this.isImportant(part, this.isBeingForced);
    }

    protected boolean isImportant(IWorkbenchPart part, boolean force) {
        return force || part instanceof IEditorPart;
    }

    public Optional<PalettePage> getPalettePage() {
        IPage currentPage = this.getCurrentPage();
        if (currentPage instanceof PalettePage) {
            return Optional.of((Object)((Object)((PalettePage)currentPage)));
        }
        return Optional.absent();
    }

    public void partActivated(IWorkbenchPart part) {
        this.partActivated(part, false);
    }

    public void partActivated(IWorkbenchPart part, boolean force) {
        if (!force && part == this) {
            return;
        }
        if (this.isImportant(part, force)) {
            this.onImportantPartActivated(part, force);
        }
    }

    private MultiPageMessageFlowEditor getMultiPageMessageFlowEditor(IWorkbenchPart part) {
        if (part instanceof MultiPageMessageFlowEditor) {
            return (MultiPageMessageFlowEditor)part;
        }
        IWorkbenchPart sitePart = part.getSite().getPart();
        if (sitePart instanceof MultiPageMessageFlowEditor) {
            return (MultiPageMessageFlowEditor)sitePart;
        }
        return null;
    }

    private void onImportantPartActivated(IWorkbenchPart part, boolean force) {
        if (force && !this.isImportant(part)) {
            this.isBeingForced = force;
            super.partActivated(part);
            this.isBeingForced = false;
            return;
        }
        IEditorPart editorPart = (IEditorPart)part;
        MultiPageMessageFlowEditor asMultiPageEditor = this.getMultiPageMessageFlowEditor(part);
        if (asMultiPageEditor != null) {
            editorPart = asMultiPageEditor.getActiveEditor();
            asMultiPageEditor.addPageChangedListener(this.pageChangedListener);
        }
        super.partActivated((IWorkbenchPart)editorPart);
        if (editorPart instanceof MessageFlowEditor && !((MessageFlowEditor)editorPart).isReadOnly()) {
            MessageFlowEditor flowEditor = (MessageFlowEditor)editorPart;
            PalettePage currentPage = (PalettePage)this.getCurrentPage();
            IMuleProject muleProject = flowEditor.getMuleProject();
            if (muleProject != currentPage.getMuleProject()) {
                currentPage.initialize(muleProject, flowEditor.getEditDomain(), this.isTestFolder(flowEditor));
            } else if (this.shouldReinitializeContents()) {
                currentPage.initialize(muleProject, flowEditor.getEditDomain(), this.isTestFolder(flowEditor));
                this.clearReinitializeState();
            }
        } else {
            Optional<PalettePage> palettePage = this.getPalettePage();
            if (palettePage.isPresent()) {
                ((PalettePage)((Object)palettePage.get())).reset();
            }
        }
    }

    private void clearReinitializeState() {
        this.runtimeChanged = false;
        this.moduleManagerChanged = false;
    }

    private boolean shouldReinitializeContents() {
        return this.runtimeChanged || this.moduleManagerChanged;
    }

    public void partOpened(IWorkbenchPart part) {
        this.partActivated(part);
    }

    public void partClosed(IWorkbenchPart part) {
        MultiPageMessageFlowEditor asMultiPageMessageFlowEditor;
        MultiPageMessageFlowEditor multiPageMessageFlowEditor = asMultiPageMessageFlowEditor = part instanceof MultiPageMessageFlowEditor ? (MultiPageMessageFlowEditor)part : null;
        if (asMultiPageMessageFlowEditor != null) {
            asMultiPageMessageFlowEditor.getEditors().forEach(iWorkbenchPart -> super.partClosed(iWorkbenchPart));
        } else {
            super.partClosed(part);
        }
        Optional activePage = MessageFlowUtils.getActiveWorkbenchPage();
        if (!activePage.isPresent()) {
            return;
        }
        if (asMultiPageMessageFlowEditor != null) {
            IWorkbenchPart activePart = ((IWorkbenchPage)activePage.get()).getActivePart();
            this.partActivated(activePart, true);
        }
        if (!MessageFlowUtils.getOpenMultipageMessageFlowEditors().isEmpty()) {
            this.focusOnNextEditor((IWorkbenchPage)activePage.get());
        }
    }

    private void focusOnNextEditor(IWorkbenchPage activePage) {
        IEditorPart targetEditor = this.getNextEditor(activePage);
        if (targetEditor != null) {
            String editorId = targetEditor.getEditorSite().getId();
            try {
                IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)targetEditor.getEditorInput(), (String)editorId, (boolean)true);
            }
            catch (PartInitException e) {
                PalettePlugin.logError("There was a problem setting focus to the next editor after closing a Mule editor", e);
                e.printStackTrace();
            }
        }
    }

    private IEditorPart getNextEditor(IWorkbenchPage activePage) {
        IEditorReference[] editorReferences = activePage.getEditorReferences();
        if (editorReferences != null && editorReferences.length > 0) {
            IEditorReference nextEditorReference = this.getNextEditorReference((IWorkbenchPart)activePage.getActiveEditor(), editorReferences);
            return nextEditorReference != null ? nextEditorReference.getEditor(true) : null;
        }
        return null;
    }

    private IEditorReference getNextEditorReference(IWorkbenchPart activePart, IEditorReference[] editorReferences) {
        IEditorReference targetEditorReference = null;
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IWorkbenchPart editorPart = editorReference.getPart(false);
            if (editorPart == activePart) {
                targetEditorReference = editorReference;
                break;
            }
            if (editorPart instanceof MultiPageMessageFlowEditor) {
                targetEditorReference = editorReference;
            }
            ++n2;
        }
        return targetEditorReference;
    }

    private MessageFlowEditor getFlowEditorFromActivePage(IWorkbenchPart part) {
        if (part instanceof MessageFlowEditor) {
            return (MessageFlowEditor)part;
        }
        if (part instanceof MultiPageMessageFlowEditor) {
            MultiPageMessageFlowEditor multiPageMessageFlowEditor = (MultiPageMessageFlowEditor)part;
            return multiPageMessageFlowEditor.getFlowEditor();
        }
        return null;
    }

    public void dispose() {
        this.eventBusHelper.unregister();
        super.dispose();
    }

    public ISearchHandler getSearchHandler() {
        return this.searchHandler;
    }

    public void setSearchHandler(ISearchHandler searchHandler) {
        this.searchHandler = searchHandler;
    }

    public void dispatchFindAndReplaceEvent() {
        if (this.getSearchHandler() != null) {
            this.getSearchHandler().handleSearch();
        } else {
            Optional<PalettePage> palettePage = this.getPalettePage();
            if (palettePage.isPresent()) {
                ((PalettePage)((Object)palettePage.get())).focusSearchBox();
            }
        }
    }

    public boolean defalultPageIsSet() {
        try {
            return super.getDefaultPage() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

