/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.mule.tooling.ui.internal.palette.core.PaletteContentFactory;
import org.mule.tooling.ui.palette.core.ModulePaletteEntry;
import org.mule.tooling.ui.palette.core.NodeDefinitionPaletteEntry;
import org.mule.tooling.ui.palette.core.PaletteCategory;
import org.mule.tooling.ui.palette.core.PaletteEntry;
import org.mule.tooling.ui.palette.core.PaletteMainEntry;
import org.mule.tooling.ui.palette.view.TooltipFactory;
import org.mule.tooling.ui.preferences.MuleStudioPreference;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class PaletteStyledCellLabelProvider
extends StyledCellLabelProvider {
    private final Color separatorColor = ThemeUtils.getCurrentTheme().getWidgetBackgroundColor();
    private static final MuleStudioPreference studioPreferences = new MuleStudioPreference();
    private static final int SEPARATOR_HEIGHT = 2;

    public void dispose() {
        super.dispose();
        this.separatorColor.dispose();
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element instanceof PaletteMainEntry) {
            this.updateDefinitionGroup(cell, element);
        } else if (element instanceof PaletteCategory) {
            this.updateCategory(cell, element);
        } else if (element instanceof NodeDefinitionPaletteEntry) {
            this.updateSimpleNodeDefinition(cell, element);
        } else if (element instanceof ModulePaletteEntry) {
            this.updateModuleDefinition(cell, element);
        } else if (element instanceof PaletteEntry && PaletteContentFactory.isDummyEntry(element)) {
            cell.setText(((PaletteEntry)element).getDisplayName());
        }
        super.update(cell);
    }

    protected void updateDefinitionGroup(ViewerCell cell, Object element) {
        PaletteMainEntry item = (PaletteMainEntry)element;
        String name = item.getDisplayName();
        StyledString styledString = this.getStyledName(name);
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setImage(item.getIcon());
    }

    protected void updateCategory(ViewerCell cell, Object element) {
        PaletteCategory item = (PaletteCategory)element;
        StyledString styledString = new StyledString(item.getDisplayName());
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setBackground(ThemeUtils.getCurrentTheme().getWidgetBackgroundColor());
    }

    protected void updateSimpleNodeDefinition(ViewerCell cell, Object element) {
        NodeDefinitionPaletteEntry item = (NodeDefinitionPaletteEntry)element;
        String name = item.getDisplayName();
        StyledString styledString = this.getStyledName(name);
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setImage(item.getIcon());
    }

    protected void updateModuleDefinition(ViewerCell cell, Object element) {
        ModulePaletteEntry item = (ModulePaletteEntry)element;
        String name = item.getDisplayName();
        StyledString styledString = this.getStyledName(name);
        cell.setText(styledString.toString());
        cell.setStyleRanges(styledString.getStyleRanges());
        cell.setImage(item.getIcon());
    }

    private StyledString getStyledName(String name) {
        StyledString styledString = null;
        if (name.contains("(")) {
            int index = name.indexOf(40);
            String value = name.substring(0, index);
            String suffix = name.substring(index);
            styledString = new StyledString(value);
            styledString.append(suffix, StyledString.DECORATIONS_STYLER);
        } else {
            styledString = new StyledString(name);
        }
        return styledString;
    }

    public String getToolTipText(Object element) {
        if (studioPreferences.showPaletteToolTips()) {
            if (element instanceof PaletteMainEntry) {
                PaletteMainEntry item = (PaletteMainEntry)element;
                return item.getTooltip();
            }
            if (element instanceof PaletteCategory) {
                PaletteCategory item = (PaletteCategory)element;
                return item.getTooltip();
            }
            if (element instanceof PaletteEntry) {
                PaletteEntry item = (PaletteEntry)element;
                String tooltip = TooltipFactory.createTooltip(item.getTooltip());
                return tooltip.length() == 0 ? null : tooltip;
            }
        }
        return null;
    }

    protected void paint(Event event, Object element) {
        PaletteMainEntry entry;
        if (element instanceof PaletteMainEntry && (entry = (PaletteMainEntry)element).getId().equals("org.mule.tooling.local")) {
            Rectangle bounds = event.getBounds();
            GC gc = event.gc;
            Color oldBackground = gc.getBackground();
            gc.setBackground(this.separatorColor);
            gc.fillRectangle(bounds.x, bounds.y + bounds.height - 2 - 1, bounds.x + bounds.width * 10, 2);
            gc.setBackground(oldBackground);
        }
        super.paint(event, element);
    }
}

