/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.ui.palette.core.PaletteCategory;
import org.mule.tooling.ui.palette.core.PaletteMainEntry;

public class PaletteState {
    private Mode mode;
    private String searchFilter = "";
    private PaletteMainEntry selectedEntry;
    private List<PaletteCategory> collapsedCategories = new ArrayList<PaletteCategory>();
    private String recentlyAddedModuleId;

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public PaletteState() {
        this.mode = Mode.ALL;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    public PaletteMainEntry getSelectedEntry() {
        return this.selectedEntry;
    }

    public void setSelectedEntry(PaletteMainEntry selectedEntry) {
        this.selectedEntry = selectedEntry;
    }

    public List<PaletteCategory> getCollapsedCategories() {
        return this.collapsedCategories;
    }

    public void setCategoryCollapsed(PaletteCategory category) {
        if (!this.collapsedCategories.contains(category)) {
            this.collapsedCategories.add(category);
        }
    }

    public void setCategoryExpanded(PaletteCategory category) {
        if (this.collapsedCategories.contains(category)) {
            this.collapsedCategories.remove(category);
        }
    }

    public void toggleCategory(PaletteCategory category) {
        if (this.collapsedCategories.contains(category)) {
            this.setCategoryExpanded(category);
        } else {
            this.setCategoryCollapsed(category);
        }
    }

    public void toggleAllCategories() {
        if (this.collapsedCategories.isEmpty()) {
            this.collapsedCategories.addAll(this.selectedEntry.getCategories());
        } else {
            this.collapsedCategories.clear();
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Optional<String> getRecentlyAddedModuleId() {
        return Optional.ofNullable(this.recentlyAddedModuleId);
    }

    public void setRecentlyAddedModuleId(String recentlyAddedModuleId) {
        this.recentlyAddedModuleId = recentlyAddedModuleId;
    }

    public void clearRecentlyAddedModuleId() {
        this.recentlyAddedModuleId = null;
    }

    public Boolean isEmptySearchFilter() {
        return "".equals(this.getSearchFilter());
    }

    public void clearSearchFilter() {
        this.setSearchFilter("");
    }

    public static enum Mode {
        ALL,
        PROJECT,
        LOCAL;

    }
}

