/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.UIJob;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.DefaultModulesLoadedEventListener;
import org.mule.tooling.core.event.IMuleModuleManagerRestartedListener;
import org.mule.tooling.core.event.IThemeChangedListener;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.FeaturedModulesTracker;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.StudioDesignContextJob;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.internal.palette.core.PaletteContentFactory;
import org.mule.tooling.ui.palette.AddModulesHelper;
import org.mule.tooling.ui.palette.IPaletteCategoryFilter;
import org.mule.tooling.ui.palette.MessageFlowEditorPaletteCategoryFilter;
import org.mule.tooling.ui.palette.PalettePlugin;
import org.mule.tooling.ui.palette.core.ModulePaletteEntry;
import org.mule.tooling.ui.palette.core.PaletteCategory;
import org.mule.tooling.ui.palette.core.PaletteEntry;
import org.mule.tooling.ui.palette.core.PaletteMainEntry;
import org.mule.tooling.ui.palette.core.SearchResult;
import org.mule.tooling.ui.palette.utils.IPaletteFavoritesChangedListener;
import org.mule.tooling.ui.palette.utils.PaletteEventTypes;
import org.mule.tooling.ui.palette.view.AddModulesComponent;
import org.mule.tooling.ui.palette.view.ModulesViewer;
import org.mule.tooling.ui.palette.view.OperationsViewer;
import org.mule.tooling.ui.palette.view.PaletteFilter;
import org.mule.tooling.ui.palette.view.PaletteInput;
import org.mule.tooling.ui.palette.view.PaletteState;
import org.mule.tooling.ui.palette.view.SearchResultViewer;
import org.mule.tooling.ui.palette.view.SelectModuleVersionDialog;
import org.mule.tooling.ui.preferences.MuleStudioPreference;
import org.mule.tooling.ui.properties.IDependencyManager;
import org.mule.tooling.ui.properties.ModuleDependencyManager;
import org.mule.tooling.ui.properties.ModuleWizardMode;
import org.mule.tooling.ui.properties.dependencies.AddDependencyWizardDialog;
import org.mule.tooling.ui.properties.dependencies.WizardDependencyMode;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.search.SearchTextField;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.ObjectHolder;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class PalettePage
extends Page {
    private static final String PROJECTMODULES_ID = "org.mule.tooling.maven.ui.projectmodules";
    private static final String ALL_LABEL = "All";
    private static final String PROJECT_LABEL = "Project";
    private static final String LOCAL_MODULES_LABEL = "Featured";
    private static final String DROP_HERE_PALETTE_PAGE_MESSAGE = "Drag and drop here\nto add to project";
    private static final String LOADING_PALETTE_PAGE_MESSAGE = "Loading...";
    private static final String PALETTE_COMPOSITE_CSS_CLASS = "Palette-Composite";
    private static final String PALETTE_VIEWER_COMPOSITE_CSS_CLASS = "Palette-Viewer-Composite";
    private static final String SEARCH_LABEL = "Search in palette";
    private static final Font categoryFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
    private Color selectedFontColor;
    private Text filterText;
    private IMuleProject muleProject;
    private Composite parentComposite;
    private Composite loadingComposite;
    private StackLayout loadingStack;
    private Composite paletteComposite;
    private SashForm sashForm;
    private ModulesViewer modulesViewer;
    private OperationsViewer operationsViewer;
    private SearchResultViewer searchResultViewer;
    private final EventBusHelper eventBusHelper = new EventBusHelper();
    private Composite paletteViewerComposite;
    private Composite searchResultsComposite;
    private Composite mainBodyComposite;
    private StackLayout mainBodyStackLayout;
    private Composite leftPaletteContent;
    private Composite installHerePage;
    private Composite modulesContentPage;
    private StackLayout modulesColumnStackLayout;
    private Composite rightPaletteContent;
    private Composite loadingFeaturedComposite;
    private StackLayout operationsColumnStackLayout;
    private Text allLabel;
    private Text projectGroupLabel;
    private Text localGroupLabel;
    private boolean isTestFolder;
    private final PaletteState paletteState;
    private static int leftWidth;
    private static int oldWeight;
    private PaletteFilter filter;
    private boolean inverted = new MuleStudioPreference().isPaletteInverted();
    private EditDomain editDomain;
    private boolean disposed;

    public PalettePage(boolean isTestFolder) {
        this.paletteState = new PaletteState();
        this.isTestFolder = isTestFolder;
        this.filter = new PaletteFilter(this.paletteState);
        this.initListeners();
    }

    private void initListeners() {
        this.eventBusHelper.registerUIListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_MODULE_MANAGER_RESTARTED, (IEventHandler)new IMuleModuleManagerRestartedListener(){

            public void onMuleModuleManagerRestarted(IMuleModuleManager muleModuleManager) {
                if (PalettePage.this.muleProject != null && PalettePage.this.muleProject.getModuleManager() == muleModuleManager) {
                    PalettePage.this.refreshPalette();
                }
            }
        });
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_THEME_CHANGED, (IEventHandler)new IThemeChangedListener(){

            public void onThemeChanged() {
                if (PalettePage.this.muleProject != null) {
                    PalettePage.this.refreshPalette();
                }
            }
        });
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), PaletteEventTypes.ON_PALETTE_FAVORITES_CHANGED, (IEventHandler)new IPaletteFavoritesChangedListener(){

            @Override
            public void onPaletteFavoritesChanged() {
                if (PalettePage.this.muleProject != null && PalettePage.this.existsActiveEditor()) {
                    PalettePage.this.refreshPalette();
                }
            }
        });
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.DEFAULT_SERVER_MODULES_LOADED, (IEventHandler)new DefaultModulesLoadedEventListener(){

            public void onDefaultModulesLoaded(IServerDefinition server) {
                if (PalettePage.this.muleProject != null && PalettePage.this.muleProject.getServerDefinition().equals(server)) {
                    Display.getDefault().asyncExec(() -> PalettePage.this.refreshPalette());
                }
            }
        });
    }

    private boolean existsActiveEditor() {
        return MessageFlowUtils.getMultiPageMessageFlowEditor() != null;
    }

    public void createControl(Composite parent) {
        this.createStackedContainer(parent);
        this.createLoadingArea();
        this.createPaletteArea();
    }

    private void createStackedContainer(Composite parent) {
        this.parentComposite = new Composite(parent, 0);
        this.loadingStack = new StackLayout();
        this.parentComposite.setLayout((Layout)this.loadingStack);
    }

    private void createLoadingArea() {
        this.loadingComposite = UiUtils.createDisabledComposite((Composite)this.parentComposite, (String)LOADING_PALETTE_PAGE_MESSAGE, (Image)PalettePlugin.getDefault().getPaletteBackground());
        GridDataFactory.fillDefaults().applyTo((Control)this.loadingComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.loadingComposite);
    }

    private void createLoadingFeaturedModulesArea() {
        this.loadingFeaturedComposite = UiUtils.createDisabledComposite((Composite)this.rightPaletteContent, (String)"Loading featured modules...", (Image)PalettePlugin.getDefault().getPaletteBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.loadingFeaturedComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 2).applyTo(this.loadingFeaturedComposite);
    }

    private void createPaletteArea() {
        this.paletteComposite = new Composite(this.parentComposite, 0);
        ThemeUtils.setCssClass((Object)this.paletteComposite, (String)PALETTE_COMPOSITE_CSS_CLASS);
        GridLayoutFactory.fillDefaults().spacing(0, 0).equalWidth(false).applyTo(this.paletteComposite);
        this.paletteComposite.setLayoutData((Object)new GridData(768));
        Composite mainComposite = this.createMainComposite(this.paletteComposite);
        this.createSearchTextField(mainComposite);
        this.createConfigurePaletteToolbar(mainComposite);
        this.mainBodyComposite = new Composite(mainComposite, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.mainBodyComposite);
        this.mainBodyStackLayout = new StackLayout();
        this.mainBodyComposite.setLayout((Layout)this.mainBodyStackLayout);
        this.paletteViewerComposite = new Composite(this.mainBodyComposite, 0);
        this.sashForm = new SashForm(this.paletteViewerComposite, 256);
        this.sashForm.SASH_WIDTH = 1;
        this.sashForm.setBackground(this.parentComposite.getDisplay().getSystemColor(15));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sashForm);
        GridLayoutFactory.fillDefaults().applyTo(this.paletteViewerComposite);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.paletteViewerComposite);
        if (this.inverted) {
            this.createPaletteModuleViewer(this.sashForm);
            this.createPaletteLeftTable(this.sashForm);
            leftWidth = 200;
        } else {
            this.createPaletteLeftTable(this.sashForm);
            this.createPaletteModuleViewer(this.sashForm);
            leftWidth = 135;
        }
        this.sashForm.setWeights(new int[]{102, 179});
        this.sashForm.addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                int width = PalettePage.this.sashForm.getClientArea().width;
                int[] weights = PalettePage.this.sashForm.getWeights();
                double perChange = Math.min((double)leftWidth / (double)width, 1.0);
                weights[0] = (int)(perChange * 1000.0);
                weights[1] = 1000 - weights[0];
                oldWeight = weights[0];
                PalettePage.this.sashForm.setWeights(weights);
            }
        });
        this.createSearchResultsComposite(this.mainBodyComposite);
        this.searchResultViewer.addFilter(this.filter);
    }

    private void onMouseEnteredModulesList() {
        this.revealComposite(this.leftPaletteContent, (Control)this.installHerePage);
    }

    private void onMouseExitModuleList() {
        this.revealComposite(this.leftPaletteContent, (Control)this.modulesContentPage);
    }

    private void createPaletteLeftTable(final SashForm paletteViewerComposite) {
        this.leftPaletteContent = new Composite((Composite)paletteViewerComposite, 0);
        this.modulesColumnStackLayout = new StackLayout();
        this.leftPaletteContent.setLayout((Layout)this.modulesColumnStackLayout);
        this.createDropModulesArea(this.leftPaletteContent);
        this.createPaletteLeftContent(this.leftPaletteContent);
        this.modulesContentPage.addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                int[] weights = paletteViewerComposite.getWeights();
                if (oldWeight != weights[0]) {
                    oldWeight = weights[0];
                    leftWidth = (int)Math.round((double)paletteViewerComposite.getClientArea().width * (double)weights[0] / (double)(weights[0] + weights[1]));
                }
            }
        });
        this.modulesColumnStackLayout.topControl = this.modulesContentPage;
    }

    private void createPaletteLeftContent(Composite contentPanel) {
        this.modulesContentPage = new Composite(contentPanel, 0);
        Color whiteColor = this.modulesContentPage.getDisplay().getSystemColor(1);
        contentPanel.setBackground(whiteColor);
        AddModulesComponent addModulesComponent = new AddModulesComponent(this.modulesContentPage, whiteColor, categoryFont, this::addModules);
        Composite addModulesComposite = addModulesComponent.createControl();
        GridDataFactory.fillDefaults().indent(0, 5).grab(true, false).applyTo((Control)addModulesComposite);
        this.modulesViewer = new ModulesViewer(this.modulesContentPage, 0x10000300);
        this.modulesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)PalettePage.this.modulesViewer.getSelection();
                PaletteMainEntry firstElement = (PaletteMainEntry)selection.getFirstElement();
                if (firstElement != null) {
                    PalettePage.this.paletteState.setSelectedEntry(firstElement);
                    List<PaletteCategory> categories = firstElement.getCategories();
                    PalettePage.this.paletteState.getCollapsedCategories().clear();
                    if ("org.mule.tooling.local".equals(firstElement.getId()) && FeaturedModulesTracker.instance().isLoading(PalettePage.this.muleProject.getServerDefinition().getId())) {
                        this.showLoadingFeaturedModulesMessage();
                    } else {
                        this.showRightPanelContentViewer();
                        this.updateRightPanelContent(categories);
                    }
                }
            }

            private void updateRightPanelContent(List<PaletteCategory> categories) {
                if (categories.isEmpty()) {
                    PalettePage.this.setOperationViewerNewInput(Collections.emptyList());
                } else if (categories.size() == 1) {
                    PalettePage.this.setOperationViewerNewInput(categories.get(0).getEntries());
                } else {
                    ArrayList<Object> treeItems = new ArrayList<Object>();
                    for (PaletteCategory category : categories) {
                        treeItems.add(category);
                        treeItems.addAll(category.getEntries());
                    }
                    PalettePage.this.setOperationViewerNewInput(treeItems);
                }
            }

            private void showRightPanelContentViewer() {
                PalettePage.this.revealComposite(PalettePage.this.rightPaletteContent, PalettePage.this.operationsViewer.getControl());
            }

            private void showLoadingFeaturedModulesMessage() {
                PalettePage.this.revealComposite(PalettePage.this.rightPaletteContent, (Control)PalettePage.this.loadingFeaturedComposite);
            }
        });
        GridLayoutFactory.fillDefaults().spacing(0, 2).applyTo(this.modulesContentPage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.modulesContentPage);
    }

    private void createDropModulesArea(Composite contentPanel) {
        this.installHerePage = UiUtils.createPaletteDropAreaComposite((Composite)contentPanel, (String)DROP_HERE_PALETTE_PAGE_MESSAGE, (Image)PalettePlugin.getDefault().getPaletteBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.installHerePage);
        GridLayoutFactory.fillDefaults().spacing(0, 2).applyTo(this.installHerePage);
        this.addDropSupport();
    }

    private void addDropSupport() {
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget((Control)this.installHerePage, 3);
        dropTarget.setTransfer(transfers);
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                Object data = event.data;
                if (data instanceof ModulePaletteEntry) {
                    ModulePaletteEntry modulePaletteEntry = (ModulePaletteEntry)data;
                    AnalyticsRecordsFactory.single((String)Events.ADD_MODULE_USING_DRAG_AND_DROP, (String[])new String[]{"moduleId", modulePaletteEntry.getId()}).track();
                    PalettePage.this.addExternalModuleIfNotPresent(modulePaletteEntry);
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.disposed = true;
        this.editDomain = null;
        this.eventBusHelper.unregister();
    }

    public void setFocus() {
    }

    private void createSearchTextField(Composite parent) {
        Composite searchTextFieldComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)searchTextFieldComposite);
        GridLayoutFactory.fillDefaults().margins(2, 2).numColumns(2).applyTo(searchTextFieldComposite);
        this.filterText = new SearchTextField(searchTextFieldComposite, SEARCH_LABEL);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)this.filterText);
        this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PalettePage.this.clearFilterSearch();
            }
        });
        this.filterText.addModifyListener(this.paletteFilterDispacher());
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    PalettePage.this.searchResultViewer.focusFirstItem();
                }
            }
        });
        this.createClearSearchLabel(searchTextFieldComposite);
    }

    private ModifyListener paletteFilterDispacher() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchTextField textWidget = (SearchTextField)e.widget;
                if (textWidget.getText().isEmpty()) {
                    List input;
                    IStructuredSelection selection = (IStructuredSelection)PalettePage.this.modulesViewer.getSelection();
                    PaletteMainEntry firstElement = (PaletteMainEntry)selection.getFirstElement();
                    if (firstElement == null && !(input = (List)PalettePage.this.modulesViewer.getInput()).isEmpty()) {
                        PalettePage.this.modulesViewer.setSelection((ISelection)new StructuredSelection((Object)PalettePage.this.getFavoritesElement(input)));
                    }
                    PalettePage.this.paletteState.clearSearchFilter();
                    PalettePage.this.showPaletteMainBody();
                } else {
                    PalettePage.this.paletteState.setSearchFilter(PalettePage.this.filterText.getText().toLowerCase());
                    List input = (List)PalettePage.this.modulesViewer.getInput();
                    Job buildSearchResult = Job.create((String)"Searching...", monitor -> {
                        this.computeSearchResult(input);
                        return Status.OK_STATUS;
                    });
                    buildSearchResult.schedule();
                    PalettePage.this.showSearchResult();
                }
            }

            private void computeSearchResult(List<PaletteMainEntry> input) {
                final List<SearchResult> searchResults = PaletteContentFactory.getSearchResults(input, PalettePage.this.muleProject, PalettePage.this.isTestFolder, PalettePage.this.filter);
                UIJob updateUIJob = new UIJob("Update UI"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        (this).PalettePage.this.searchResultViewer.setInput(searchResults);
                        return Status.OK_STATUS;
                    }
                };
                updateUIJob.schedule();
            }
        };
    }

    private void createClearSearchLabel(Composite searchTextFieldComposite) {
        Text clearLabel = new Text(searchTextFieldComposite, 8);
        clearLabel.setText("Clear");
        clearLabel.setFont(categoryFont);
        clearLabel.setForeground(this.getSelectedFontColor());
        this.addMainActionListener(clearLabel, this::clearFilterSearch);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)clearLabel);
    }

    private void createConfigurePaletteToolbar(Composite paletteComposite) {
        ToolBar toolBar = new ToolBar(paletteComposite, 256);
        GridLayoutFactory.fillDefaults().applyTo((Composite)toolBar);
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(false, false).applyTo((Control)toolBar);
        ToolItem mainItem = new ToolItem(toolBar, 8);
        mainItem.setImage(MuleImages.SETTINGS_IMAGE);
        mainItem.setToolTipText("Add Modules");
        mainItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                AnalyticsRecordsFactory.single((String)Events.MANAGE_MODULES, (IMuleProject)PalettePage.this.muleProject).addMetadata("origin", "palette").track();
                String[] otherPagesIds = new String[]{PalettePage.PROJECTMODULES_ID};
                PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)PalettePage.this.muleProject.getProject(), (String)PalettePage.PROJECTMODULES_ID, (String[])otherPagesIds, null, (int)1).open();
            }
        });
        toolBar.pack();
    }

    private void createPaletteModuleViewer(SashForm paletteViewerComposite) {
        this.rightPaletteContent = new Composite((Composite)paletteViewerComposite, 0);
        this.operationsColumnStackLayout = new StackLayout();
        this.rightPaletteContent.setLayout((Layout)this.operationsColumnStackLayout);
        this.createLoadingFeaturedModulesArea();
        this.operationsViewer = new OperationsViewer(this.rightPaletteContent, 4, this.paletteState, this::onMouseEnteredModulesList, this::onMouseExitModuleList);
        this.operationsColumnStackLayout.topControl = this.operationsViewer.getControl();
    }

    private void createSearchResultsComposite(Composite mainBodyComposite) {
        this.searchResultsComposite = new Composite(mainBodyComposite, 0);
        Composite labelsComposite = new Composite(this.searchResultsComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(labelsComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)labelsComposite);
        Label label = new Label(labelsComposite, 0);
        label.setFont(categoryFont);
        label.setText("Search in palette:");
        this.allLabel = new Text(labelsComposite, 8);
        this.allLabel.setFont(categoryFont);
        this.allLabel.setForeground(this.getSelectedFontColor());
        this.allLabel.setText(ALL_LABEL);
        this.addMainActionListener(this.allLabel, () -> this.switchSelectedFilterMode(PaletteState.Mode.ALL, this.allLabel, this.projectGroupLabel, this.localGroupLabel));
        this.projectGroupLabel = new Text(labelsComposite, 8);
        this.projectGroupLabel.setFont(categoryFont);
        this.projectGroupLabel.setText(PROJECT_LABEL);
        this.addMainActionListener(this.projectGroupLabel, () -> this.switchSelectedFilterMode(PaletteState.Mode.PROJECT, this.projectGroupLabel, this.allLabel, this.localGroupLabel));
        this.localGroupLabel = new Text(labelsComposite, 8);
        this.localGroupLabel.setFont(categoryFont);
        this.localGroupLabel.setText(LOCAL_MODULES_LABEL);
        this.addMainActionListener(this.localGroupLabel, () -> this.switchSelectedFilterMode(PaletteState.Mode.LOCAL, this.localGroupLabel, this.allLabel, this.projectGroupLabel));
        this.searchResultViewer = new SearchResultViewer(this.searchResultsComposite, 768, this.paletteState, this::addModules);
        this.addSearchResultsFooter(this.searchResultsComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.searchResultsComposite);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.searchResultsComposite);
    }

    private void switchSelectedFilterMode(PaletteState.Mode mode, Text selectedModeLabel, Text ... unselectedModeLabels) {
        Text[] textArray = unselectedModeLabels;
        int n = unselectedModeLabels.length;
        int n2 = 0;
        while (n2 < n) {
            Text text = textArray[n2];
            text.setForeground(ThemeUtils.getCurrentTheme().getPaletteFiltersForeground());
            ++n2;
        }
        selectedModeLabel.setForeground(this.getSelectedFontColor());
        this.paletteState.setMode(mode);
        this.searchResultViewer.refresh();
    }

    private void addSearchResultsFooter(Composite parent) {
        Label separator = new Label(parent, 258);
        GridDataFactory.fillDefaults().span(0, 0).align(4, 4).grab(true, false).applyTo((Control)separator);
        Label message = new Label(parent, 0);
        message.setText("Can't find what you are looking for?");
        GridDataFactory.fillDefaults().span(1, 0).align(0x1000000, 1).grab(true, false).applyTo((Control)message);
        Link link = new Link(this.searchResultsComposite, 0);
        link.setText("<a>Try looking for it in Exchange</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PalettePage.this.addModules();
            }
        });
        GridDataFactory.fillDefaults().span(1, 4).align(0x1000000, 1).grab(true, false).applyTo((Control)link);
    }

    private Color getSelectedFontColor() {
        if (this.selectedFontColor == null) {
            this.selectedFontColor = new Color(59, 153, 252);
        }
        return this.selectedFontColor;
    }

    private Composite createMainComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(0, 0).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        ThemeUtils.setCssClass((Object)composite, (String)PALETTE_VIEWER_COMPOSITE_CSS_CLASS);
        return composite;
    }

    private void recreatePageInput() {
        this.operationsViewer.setEditDomain(this.editDomain);
        this.searchResultViewer.setEditDomain(this.editDomain);
        if (!this.modulesViewer.hasInput()) {
            this.showLoadingMessage();
        }
        final PaletteContentCreateRequest paletteContentRequest = new PaletteContentCreateRequest(this.muleProject, (ObjectHolder<List<PaletteMainEntry>>)new ObjectHolder());
        StudioDesignContextJob createPaletteContent = new StudioDesignContextJob("Loading palette...", this.muleProject, EditingScope.getCurrent()){

            protected IStatus doRun(IProgressMonitor monitor) {
                paletteContentRequest.paletteContentHolder.set(PaletteContentFactory.createFrom(paletteContentRequest.muleProject, PalettePage.this.isTestFolder));
                return Status.OK_STATUS;
            }
        };
        createPaletteContent.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PalettePage.this.scheduleUiUpdate(paletteContentRequest);
            }
        });
        createPaletteContent.schedule();
    }

    private void showPaletteMainComposite() {
        this.revealComposite(this.parentComposite, (Control)this.paletteComposite);
    }

    private void revealComposite(Composite stackingComposite, Control compositeToReveal) {
        StackLayout stackLayout = (StackLayout)stackingComposite.getLayout();
        if (stackLayout.topControl != compositeToReveal) {
            stackLayout.topControl = compositeToReveal;
            stackingComposite.layout();
        }
    }

    private void showLoadingMessage() {
        this.setEmptyInput();
        this.revealComposite(this.parentComposite, (Control)this.loadingComposite);
    }

    private void setEmptyInput() {
        PaletteInput paletteInput = new PaletteInput(this.muleProject, Collections.emptyList());
        this.modulesViewer.setInput(paletteInput);
    }

    private void scheduleUiUpdate(final PaletteContentCreateRequest paletteContentRequest) {
        UIJob updatePaletteCotent = new UIJob("Creating palette content"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (paletteContentRequest.muleProject == PalettePage.this.muleProject) {
                    List input = (List)paletteContentRequest.paletteContentHolder.get();
                    if (!PalettePage.this.modulesViewer.getControl().isDisposed()) {
                        PalettePage.this.showPaletteMainComposite();
                        PalettePage.this.initPaletteInputWith(input);
                        PalettePage.this.showPaletteMainBody();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        updatePaletteCotent.schedule();
    }

    private void initPaletteInputWith(List<PaletteMainEntry> input) {
        PaletteInput paletteInput = new PaletteInput(this.muleProject, input);
        this.modulesViewer.setInput(paletteInput);
        if (!input.isEmpty()) {
            PaletteMainEntry selectedElement = this.getFavoritesElement(input);
            List<PaletteEntry> category = selectedElement.getCategories().get(0).getEntries();
            if (this.paletteState.getRecentlyAddedModuleId().isPresent()) {
                this.setOperationViewerNewInput(category);
                String recentlyAddedModuleId = this.paletteState.getRecentlyAddedModuleId().get();
                selectedElement = input.stream().filter(x -> x.getId().equals(recentlyAddedModuleId)).findAny().orElse(selectedElement);
                this.modulesViewer.setSelection((ISelection)new StructuredSelection((Object)selectedElement), true);
                if (!category.isEmpty()) {
                    this.operationsViewer.setSelection((ISelection)new StructuredSelection((Object)category.get(0)));
                } else {
                    this.operationsViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                this.operationsViewer.getControl().forceFocus();
                this.paletteState.clearRecentlyAddedModuleId();
            } else if (this.modulesViewer.getSelection().isEmpty()) {
                this.setOperationViewerNewInput(category);
                this.modulesViewer.setSelection((ISelection)new StructuredSelection((Object)selectedElement));
            }
        }
    }

    private void showPaletteMainBody() {
        this.revealComposite(this.mainBodyComposite, (Control)this.paletteViewerComposite);
    }

    private void showSearchResult() {
        this.revealComposite(this.mainBodyComposite, (Control)this.searchResultsComposite);
    }

    private PaletteMainEntry getFavoritesElement(List<PaletteMainEntry> input) {
        return input.stream().filter(x -> x.getId().equals("org.mule.tooling.favorites")).findFirst().get();
    }

    public void focusSearchBox() {
        if (this.filterText != null) {
            this.filterText.setFocus();
        }
    }

    public void refreshPalette() {
        this.recreatePageInput();
        this.clearFilterSearch();
    }

    private void clearFilterSearch() {
        this.filterText.setText("");
        this.paletteState.clearSearchFilter();
        this.switchSelectedFilterMode(PaletteState.Mode.ALL, this.allLabel, this.projectGroupLabel, this.localGroupLabel);
    }

    protected IPaletteCategoryFilter createCategoryFilter() {
        return new MessageFlowEditorPaletteCategoryFilter();
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public void setInput(List<PaletteEntry> selectedItems) {
        this.setOperationViewerNewInput(selectedItems);
        if (this.shouldShowNoResultsMessage()) {
            this.showSearchResult();
        } else {
            this.showPaletteMainBody();
        }
    }

    private boolean shouldShowNoResultsMessage() {
        return StringUtils.isNotEmpty((String)this.filterText.getText());
    }

    private void setOperationViewerNewInput(Object input) {
        this.operationsViewer.setInput(input);
    }

    public Control getControl() {
        return this.parentComposite;
    }

    public void reset() {
        this.muleProject = null;
        this.editDomain = null;
    }

    public void initialize(IMuleProject muleProject, EditDomain editDomain, boolean isTestFolder) {
        this.isTestFolder = isTestFolder;
        this.muleProject = muleProject;
        this.editDomain = editDomain;
        this.refreshPalette();
    }

    private void addModules() {
        AddModulesHelper.create(this.muleProject, () -> {
            AddDependencyWizardDialog dialog = AddDependencyWizardDialog.create((Shell)Display.getDefault().getActiveShell(), (WizardDependencyMode)new ModuleWizardMode((IDependencyManager)new ModuleDependencyManager(this.muleProject), this.filterText.getText()));
            if (dialog.open() == 0) {
                List modulesToAdd = dialog.getResult();
                if (!modulesToAdd.isEmpty()) {
                    ExternalContributionMuleModule externalContributionMuleModule = (ExternalContributionMuleModule)modulesToAdd.get(0);
                    AnalyticsRecordsFactory.single((String)Events.ADD_MODULE_FROM_SEARCH_IN_EXCHANGE, (IMuleProject)this.muleProject).withModuleProperty(modulesToAdd).track();
                    this.paletteState.setRecentlyAddedModuleId(externalContributionMuleModule.getId());
                }
                return modulesToAdd;
            }
            return Collections.emptyList();
        }).addModules();
    }

    private void addExternalModuleIfNotPresent(ModulePaletteEntry modulePaletteEntry) {
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        Optional externalModule = MuleCorePlugin.getModuleContributionManager().getExternalModule(muleProject.getServerDefinition(), modulePaletteEntry.getId());
        if (externalModule.isPresent()) {
            AddModulesHelper.create(muleProject, () -> {
                ExternalContributionMuleModule muleModule = (ExternalContributionMuleModule)externalModule.get();
                if (!modulePaletteEntry.getAlternativeModules().isEmpty()) {
                    List<ExternalContributionMuleModule> availableModules = this.getModulesListFromEntry(modulePaletteEntry);
                    SelectModuleVersionDialog dialog = new SelectModuleVersionDialog(Display.getCurrent().getActiveShell(), muleProject, availableModules);
                    int open = dialog.open();
                    if (open == 0) {
                        muleModule = dialog.getSelectedModule();
                    } else {
                        return Collections.emptyList();
                    }
                }
                this.paletteState.setRecentlyAddedModuleId(muleModule.getId());
                return Arrays.asList(muleModule);
            }).addModules();
        }
    }

    private List<ExternalContributionMuleModule> getModulesListFromEntry(ModulePaletteEntry modulePaletteEntry) {
        ArrayList<ExternalContributionMuleModule> availableModules = new ArrayList<ExternalContributionMuleModule>(1 + modulePaletteEntry.getAlternativeModules().size());
        availableModules.add(modulePaletteEntry.getModule());
        availableModules.addAll(modulePaletteEntry.getAlternativeModules());
        return availableModules;
    }

    private void addMainActionListener(Text text, final Runnable action) {
        text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                action.run();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10 || e.keyCode == 32) {
                    action.run();
                }
            }
        });
    }

    private static class PaletteContentCreateRequest {
        public final IMuleProject muleProject;
        public final ObjectHolder<List<PaletteMainEntry>> paletteContentHolder;

        public PaletteContentCreateRequest(IMuleProject project, ObjectHolder<List<PaletteMainEntry>> content) {
            this.muleProject = project;
            this.paletteContentHolder = content;
        }
    }
}

