/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.mule.tooling.model.module.Keyword;
import org.mule.tooling.ui.palette.core.SearchResult;
import org.mule.tooling.ui.palette.view.PaletteState;

public class PaletteFilter
extends ViewerFilter {
    private final PaletteState paletteState;

    public PaletteFilter(PaletteState paletteState) {
        this.paletteState = paletteState;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.shouldShowResult((SearchResult)element);
    }

    public boolean shouldShowResult(SearchResult result) {
        String currentFilter = this.paletteState.getSearchFilter().toLowerCase().trim();
        if (StringUtils.isBlank((CharSequence)currentFilter)) {
            return true;
        }
        if (SearchResult.EMPTY == result) {
            return false;
        }
        if (!PaletteState.Mode.ALL.equals((Object)this.paletteState.getMode()) && (PaletteState.Mode.PROJECT.equals((Object)this.paletteState.getMode()) ? !result.isLocalResult() : result.isLocalResult())) {
            return false;
        }
        return this.searchResultMatchesKeywords(result, currentFilter);
    }

    private boolean searchResultMatchesKeywords(SearchResult result, String currentFilter) {
        boolean matchesKeywords = false;
        String[] keyWords = currentFilter.trim().split(" ");
        String nodeDisplayName = result.getNode().getDisplayName().toLowerCase();
        if (keyWords.length == 1) {
            String groupDisplayName = result.getGroup().getDisplayName().toLowerCase();
            matchesKeywords = groupDisplayName.contains(currentFilter) || nodeDisplayName.contains(currentFilter) || this.matchesKeywords(result, currentFilter);
        } else {
            String groupDisplayName = result.getGroup().getDisplayName().toLowerCase();
            int startingIndex = 0;
            if (groupDisplayName.contains(keyWords[0])) {
                startingIndex = 1;
            }
            matchesKeywords = this.containsAllKeywordsStartingAt(nodeDisplayName, keyWords, startingIndex);
        }
        return matchesKeywords;
    }

    private boolean matchesKeywords(SearchResult result, String currentFilter) {
        boolean matchesKeywords = false;
        for (Keyword keyword : result.getNode().getNodeDefinition().getKeywords()) {
            if (!keyword.getKeyword().toLowerCase().contains(currentFilter)) continue;
            matchesKeywords = true;
        }
        return matchesKeywords;
    }

    public boolean containsAllKeywordsStartingAt(String term, String[] keywords, int startingIndex) {
        int i = startingIndex;
        while (i < keywords.length) {
            if (!term.contains(keywords[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

